/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins.jee;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.jee.AbstractPlugin;

public class HistoryPlugin
extends AbstractPlugin {
    public ItemCollection documentContext;
    public ItemCollection documentActivity;
    List<List<Object>> historyList = null;
    private static Logger logger = Logger.getLogger(HistoryPlugin.class.getName());

    @Override
    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        String rtfItemLog;
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        if (this.documentContext.hasItem("txtworkflowhistorylogrev")) {
            this.convertOldFormat();
            this.documentContext.removeItem("txtworkflowhistorylogrev");
        }
        if ((rtfItemLog = this.documentActivity.getItemValueString("rtfresultlog")).isEmpty()) {
            return 0;
        }
        rtfItemLog = this.replaceDynamicValues(rtfItemLog, this.documentContext);
        List temp = this.documentContext.getItemValue("txtworkflowhistory");
        this.historyList = new Vector<List<Object>>();
        for (Object o : temp) {
            if (!(o instanceof List)) continue;
            this.historyList.add((List)o);
        }
        ArrayList<Object> newEntry = new ArrayList<Object>();
        newEntry.add(new Date());
        newEntry.add(rtfItemLog);
        newEntry.add(this.getUserName());
        this.historyList.add(newEntry);
        int iMaxLogLength = this.documentContext.getItemValueInteger("numworkflowhistoryLength");
        if (iMaxLogLength > 0) {
            while (this.historyList.size() > iMaxLogLength) {
                this.historyList.remove(0);
            }
        }
        return 0;
    }

    @Override
    public void close(int status) throws PluginException {
        if (status < 2) {
            if (this.historyList != null) {
                this.documentContext.replaceItemValue("txtworkflowhistory", this.historyList);
            }
            this.documentContext.replaceItemValue("timworkflowlastaccess", (Object)new Date());
        }
    }

    protected void convertOldFormat() {
        ArrayList newList = new ArrayList();
        try {
            List oldList = this.documentContext.getItemValue("txtworkflowhistorylog");
            for (String oldEntry : oldList) {
                if (oldEntry == null || oldEntry.isEmpty() || oldEntry.indexOf(" : ") <= -1) continue;
                String sDate = oldEntry.substring(0, oldEntry.indexOf(" : "));
                String sComment = oldEntry.substring(oldEntry.indexOf(" : ") + 3);
                String sUser = "";
                ArrayList<Object> newEntry = new ArrayList<Object>();
                newEntry.add(this.convertDate(sDate));
                newEntry.add(sComment);
                newEntry.add(sUser);
                newList.add(newEntry);
            }
        }
        catch (ClassCastException cce) {
            logger.warning("[HistoryPlugin] can not convert txtworkflowhistorylog into new format!");
            logger.warning(cce.getMessage());
        }
        this.documentContext.replaceItemValue("txtworkflowhistory", newList);
    }

    private Date convertDate(String aDateString) {
        DateFormat df = null;
        try {
            df = DateFormat.getDateTimeInstance(1, 1, new Locale("de", "DE"));
            Date result = df.parse(aDateString);
            return result;
        }
        catch (ParseException e) {
            try {
                df = DateFormat.getDateTimeInstance(2, 2, new Locale("de", "DE"));
                Date result = df.parse(aDateString);
                return result;
            }
            catch (ParseException e2) {
                try {
                    df = DateFormat.getDateTimeInstance(3, 3, new Locale("de", "DE"));
                    Date result = df.parse(aDateString);
                    return result;
                }
                catch (ParseException e3) {
                    try {
                        df = DateFormat.getDateTimeInstance(1, 2, new Locale("de", "DE"));
                        Date result = df.parse(aDateString);
                        return result;
                    }
                    catch (ParseException e4) {
                        try {
                            df = DateFormat.getDateTimeInstance(2, 3, new Locale("de", "DE"));
                            Date result = df.parse(aDateString);
                            return result;
                        }
                        catch (ParseException e5) {
                            try {
                                df = DateFormat.getDateTimeInstance(3, 2, new Locale("de", "DE"));
                                Date result = df.parse(aDateString);
                                return result;
                            }
                            catch (ParseException e6) {
                                try {
                                    df = DateFormat.getDateTimeInstance(2, 1, new Locale("de", "DE"));
                                    Date result = df.parse(aDateString);
                                    return result;
                                }
                                catch (ParseException e7) {
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

