/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;

public class ResultPlugin
extends AbstractPlugin {
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    ItemCollection documentContext;
    String sActivityResult;
    private static Logger logger = Logger.getLogger(ResultPlugin.class.getName());

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.sActivityResult = adocumentActivity.getItemValueString("txtActivityResult");
        this.sActivityResult = this.replaceDynamicValues(this.sActivityResult, adocumentContext);
        try {
            ResultPlugin.evaluate(this.sActivityResult, adocumentContext);
        }
        catch (Exception e) {
            throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "ResultPlguin: invalid format : " + this.sActivityResult + " Error: " + e.getMessage());
        }
        return 0;
    }

    public void close(int status) throws PluginException {
        try {
            if (status < 2) {
                this.documentContext.replaceItemValue("txtworkflowresultmessage", (Object)this.sActivityResult);
            }
        }
        catch (Exception e) {
            System.out.println("[ResultPlugin] Error close(): " + e.toString());
        }
    }

    public static void evaluate(String aString, ItemCollection documentContext) throws PluginException {
        int iTagStartPos;
        String sName = "";
        String sType = " ";
        if (aString == null) {
            return;
        }
        while ((iTagStartPos = aString.toLowerCase().indexOf("<item")) != -1) {
            int iTagEndPos = aString.toLowerCase().indexOf("</item>", iTagStartPos);
            if (iTagEndPos == -1) {
                throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "</item>  expected!");
            }
            int iContentStartPos = 0;
            int iContentEndPos = 0;
            int iNameStartPos = 0;
            int iNameEndPos = 0;
            int iTypeStartPos = 0;
            int iTypeEndPos = 0;
            sName = "";
            sType = " ";
            String sItemValue = "";
            iContentEndPos = iTagEndPos;
            String sTestString = aString.substring(0, iContentEndPos);
            iContentStartPos = sTestString.lastIndexOf(62) + 1;
            if (iContentStartPos >= iContentEndPos) {
                return;
            }
            iTagEndPos += "</item>".length();
            iNameStartPos = aString.toLowerCase().indexOf("name=", iTagStartPos);
            if (iNameStartPos > -1 && iNameStartPos < iContentStartPos) {
                String sNamePart = aString.substring(0, iContentStartPos);
                sNamePart = sNamePart.replace("'", "\"");
                iNameStartPos = sNamePart.indexOf("\"", iNameStartPos) + 1;
                iNameEndPos = sNamePart.indexOf("\"", iNameStartPos + 1);
                sName = sNamePart.substring(iNameStartPos, iNameEndPos);
            }
            if ((iTypeStartPos = aString.toLowerCase().indexOf("type=", iTagStartPos)) > -1 && iTypeStartPos < iContentStartPos) {
                String sTypePart = aString.substring(0, iContentStartPos);
                sTypePart = sTypePart.replace("'", "\"");
                iTypeStartPos = sTypePart.indexOf("\"", iTypeStartPos) + 1;
                iTypeEndPos = sTypePart.indexOf("\"", iTypeStartPos + 1);
                sType = sTypePart.substring(iTypeStartPos, iTypeEndPos);
            }
            sItemValue = aString.substring(iContentStartPos, iContentEndPos);
            if (sName != null && !"".equals(sName)) {
                if (sName.startsWith("$")) {
                    logger.warning("ResultPlugin - item '" + sName + "' can not be updated!");
                } else {
                    Object oValue = sItemValue;
                    if ("boolean".equalsIgnoreCase(sType)) {
                        oValue = Boolean.valueOf(sItemValue);
                    }
                    if ("integer".equalsIgnoreCase(sType)) {
                        oValue = new Integer(sItemValue);
                    }
                    documentContext.replaceItemValue(sName, oValue);
                }
            }
            aString = aString.substring(0, iTagStartPos) + "" + aString.substring(iTagEndPos);
        }
    }
}

