/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;

public class IntervalPlugin
extends AbstractPlugin {
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    ItemCollection documentContext;
    String sActivityResult;
    private static Logger logger = Logger.getLogger(IntervalPlugin.class.getName());

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        if (!"1".equals(adocumentActivity.getItemValueString("keyScheduledActivity"))) {
            return 0;
        }
        this.documentContext = adocumentContext;
        Calendar calNow = Calendar.getInstance();
        logger.fine("[IntervalPlugin] compute next interval dates for workitem " + this.documentContext.getItemValueString("$uniqueid"));
        Set fieldNames = this.documentContext.getAllItems().keySet();
        for (String fieldName : fieldNames) {
            Date date;
            String sInterval;
            if (!fieldName.toLowerCase().startsWith("keyinterval") || (sInterval = this.documentContext.getItemValueString(fieldName)).isEmpty()) continue;
            sInterval = sInterval.toLowerCase();
            String sDateField = fieldName.substring(11);
            if (sDateField.isEmpty() || !this.documentContext.hasItem(sDateField) || (date = this.documentContext.getItemValueDate(sDateField)) == null) continue;
            Calendar calDate = Calendar.getInstance();
            calDate.setTime(date);
            if (!calNow.after(calDate)) continue;
            logger.fine("[IntervalPlugin] compute next interval for " + sDateField);
            if (sInterval.contains("weekly")) {
                calDate.add(5, 7);
            }
            if (sInterval.contains("monthly")) {
                calDate.add(2, 1);
            }
            if (sInterval.contains("yearly")) {
                calDate.add(1, 1);
            }
            this.documentContext.replaceItemValue(sDateField, (Object)calDate.getTime());
        }
        return 0;
    }

    public void close(int status) throws PluginException {
    }
}

