/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;

public class HistoryPlugin
extends AbstractPlugin {
    public ItemCollection documentContext;
    public ItemCollection documentActivity;
    List vOldProt;
    List vOldProtRev;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        int iZeitFormat;
        int iDatumsFormat;
        String aProtokoll;
        block16: {
            String sZeitFormat;
            String rtfItemResult;
            this.documentContext = adocumentContext;
            this.documentActivity = adocumentActivity;
            aProtokoll = rtfItemResult = this.documentActivity.getItemValueString("rtfresultlog");
            String sDatumsFormat = this.documentActivity.getItemValueString("keyLogDateFormat");
            if (sDatumsFormat == null || "".equals(sDatumsFormat)) {
                sDatumsFormat = "1";
            }
            if ((sZeitFormat = this.documentActivity.getItemValueString("keylogtimeformat")) == null || "".equals(sZeitFormat)) {
                sZeitFormat = "2";
            }
            if (this.ctx.getLogLevel() == 2) {
                logger.info("[HistoryPlugin] logtimeformat=" + sZeitFormat);
            }
            if (this.ctx.getLogLevel() == 2) {
                logger.info("[HistoryPlugin] logdateformat=" + sDatumsFormat);
            }
            iDatumsFormat = -1;
            iZeitFormat = -1;
            try {
                iDatumsFormat = Integer.parseInt(sDatumsFormat);
                iZeitFormat = Integer.parseInt(sZeitFormat);
            }
            catch (NumberFormatException nfe) {
                if (this.ctx.getLogLevel() < 1) break block16;
                logger.severe("[HistoryPlugin] error logtimeformat " + nfe.toString());
            }
        }
        String sTim = "";
        if (iZeitFormat > -1 && iDatumsFormat > -1) {
            sTim = DateFormat.getDateTimeInstance(iDatumsFormat, iZeitFormat).format(new Date());
        } else if (iZeitFormat == -1 && iDatumsFormat > -1) {
            sTim = DateFormat.getDateInstance(iDatumsFormat).format(new Date());
        } else if (iZeitFormat > -1 && iDatumsFormat == -1) {
            sTim = DateFormat.getTimeInstance(iZeitFormat).format(new Date());
        }
        if (!"".equals(aProtokoll)) {
            String sDoppelpunkt = "";
            if (!"".equals(sTim) && !"".equals(aProtokoll)) {
                sDoppelpunkt = " : ";
            }
            aProtokoll = sTim + sDoppelpunkt + aProtokoll;
            aProtokoll = this.replaceDynamicValues(aProtokoll, this.documentContext);
            this.vOldProt = this.documentContext.getItemValue("txtworkflowhistorylog");
            this.vOldProtRev = this.documentContext.getItemValue("txtworkflowhistorylogrev");
            this.vOldProt.add(aProtokoll);
            this.vOldProtRev.add(0, aProtokoll);
            int iMaxLogLength = this.documentContext.getItemValueInteger("numworkflowhistoryLength");
            if (iMaxLogLength > 0) {
                while (this.vOldProt.size() > iMaxLogLength) {
                    this.vOldProt.remove(0);
                }
                while (this.vOldProtRev.size() > iMaxLogLength) {
                    this.vOldProtRev.remove(this.vOldProtRev.size() - 1);
                }
            }
        }
        return 0;
    }

    public void close(int status) throws PluginException {
        if (status < 2) {
            if (this.vOldProt != null) {
                this.documentContext.replaceItemValue("txtworkflowhistorylog", (Object)this.vOldProt);
            }
            if (this.vOldProtRev != null) {
                this.documentContext.replaceItemValue("txtworkflowhistorylogrev", (Object)this.vOldProtRev);
            }
            Date date = new Date();
            this.documentContext.replaceItemValue("timworkflowlastaccess", (Object)date);
        }
    }
}

