/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;

public abstract class AbstractPlugin
implements Plugin {
    public WorkflowContext ctx;

    public void init(WorkflowContext actx) throws PluginException {
        this.ctx = actx;
    }

    public String replaceDynamicValues(String aString, ItemCollection documentContext) {
        int iTagStartPos;
        String sFormat = "";
        String sSeparator = " ";
        if (aString == null) {
            return "";
        }
        while ((iTagStartPos = aString.toLowerCase().indexOf("<itemvalue")) != -1) {
            int iTagEndPos = aString.toLowerCase().indexOf("</itemvalue>", iTagStartPos);
            if (iTagEndPos == -1) {
                return aString;
            }
            int iContentStartPos = 0;
            int iContentEndPos = 0;
            int iFormatStartPos = 0;
            int iFormatEndPos = 0;
            int iSeparatorStartPos = 0;
            int iSeparatorEndPos = 0;
            sFormat = "";
            sSeparator = " ";
            String sItemValue = "";
            iContentEndPos = iTagEndPos;
            String sTestString = aString.substring(0, iContentEndPos);
            iContentStartPos = sTestString.lastIndexOf(62) + 1;
            if (iContentStartPos >= iContentEndPos) {
                return aString;
            }
            iTagEndPos += "</itemvalue>".length();
            iFormatStartPos = aString.toLowerCase().indexOf("format=", iTagStartPos);
            if (iFormatStartPos > -1 && iFormatStartPos < iContentStartPos) {
                iFormatStartPos = aString.indexOf("\"", iFormatStartPos) + 1;
                iFormatEndPos = aString.indexOf("\"", iFormatStartPos + 1);
                sFormat = aString.substring(iFormatStartPos, iFormatEndPos);
            }
            if ((iSeparatorStartPos = aString.toLowerCase().indexOf("separator=", iTagStartPos)) > -1 && iSeparatorStartPos < iContentStartPos) {
                iSeparatorStartPos = aString.indexOf("\"", iSeparatorStartPos) + 1;
                iSeparatorEndPos = aString.indexOf("\"", iSeparatorStartPos + 1);
                sSeparator = aString.substring(iSeparatorStartPos, iSeparatorEndPos);
            }
            sItemValue = aString.substring(iContentStartPos, iContentEndPos);
            List vValue = documentContext.getItemValue(sItemValue);
            String sResult = this.formatItemValues(vValue, sSeparator, sFormat);
            aString = aString.substring(0, iTagStartPos) + sResult + aString.substring(iTagEndPos);
        }
        return aString;
    }

    public String formatItemValues(Collection aItem, String aSeparator, String sFormat) {
        StringBuffer sBuffer = new StringBuffer();
        if (aItem == null) {
            return "";
        }
        for (Object aSingleValue : aItem) {
            String aValue = this.formatObjectValue(aSingleValue, sFormat);
            sBuffer.append(aValue);
            sBuffer.append(aSeparator);
        }
        String sString = sBuffer.toString();
        if (sString.endsWith(aSeparator)) {
            sString = sString.substring(0, sString.lastIndexOf(aSeparator));
        }
        return sString;
    }

    private String formatObjectValue(Object o, String format) {
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            String singleValue = "";
            if (format != null && !"".equals(format)) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat(format);
                    singleValue = formatter.format(dateValue);
                }
                catch (Exception ef) {
                    Logger logger = Logger.getLogger(AbstractPlugin.class.getName());
                    logger.warning("AbstractPlugin: Invalid format String '" + format + "'");
                    logger.warning("AbstractPlugin: Can not format value - error: " + ef.getMessage());
                    return "" + dateValue;
                }
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
            return singleValue;
        }
        return o.toString();
    }

    public void mergeVectors(List p_VectorDestination, List p_VectorSource) {
        if (p_VectorSource != null && p_VectorSource.size() > 0) {
            for (Object o : p_VectorSource) {
                if (p_VectorDestination.indexOf(o) != -1) continue;
                p_VectorDestination.add(o);
            }
        }
    }

    public void mergeMappedFieldValues(ItemCollection documentContext, List p_VectorDestination, List<String> p_VectorFieldList) {
        if (p_VectorDestination == null || p_VectorFieldList == null) {
            return;
        }
        if (p_VectorFieldList.size() > 0) {
            for (String sFeldName : p_VectorFieldList) {
                List vValues = documentContext.getItemValue(sFeldName);
                if (vValues == null || vValues.size() <= 0) continue;
                for (Object o : vValues) {
                    if (p_VectorDestination.indexOf(o) != -1) continue;
                    p_VectorDestination.add(o);
                }
            }
        }
    }

    public List uniqueList(List p_Vector) {
        int iVectorSize = p_Vector.size();
        Vector cleanedVector = new Vector();
        for (int i = 0; i < iVectorSize; ++i) {
            Object o = p_Vector.get(i);
            if (o == null || cleanedVector.indexOf(o) > -1 || "".equals(o.toString())) continue;
            cleanedVector.add(o);
        }
        p_Vector = cleanedVector;
        if (p_Vector.size() == 0) {
            p_Vector.add("");
        }
        return p_Vector;
    }
}

