/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.util;

import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;

@Singleton
public class PropertyService {
    private Properties properties = null;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    @PostConstruct
    void init() {
        this.loadProperties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void reset() {
        logger.fine("reset properties....");
        this.properties = null;
        this.loadProperties();
    }

    private void loadProperties() {
        this.properties = new Properties();
        try {
            this.properties.load(Thread.currentThread().getContextClassLoader().getResource("imixs.properties").openStream());
        }
        catch (Exception e) {
            logger.warning("PropertyService unable to find imixs.properties in current classpath");
            e.printStackTrace();
        }
    }
}

