/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.ScheduleExpression;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ejb.WorkflowSchedulerServiceRemote;
import org.imixs.workflow.jee.ejb.WorkflowService;

@Stateless
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class WorkflowSchedulerService
implements WorkflowSchedulerServiceRemote {
    public static final String TYPE = "configuration";
    public static final String NAME = "org.imixs.workflow.scheduler";
    private static Logger logger = Logger.getLogger(WorkflowSchedulerService.class.getName());
    @EJB
    WorkflowService workflowService;
    @EJB
    EntityService entityService;
    @EJB
    ModelService modelService;
    @Resource
    TimerService timerService;
    @Resource
    SessionContext ctx;
    int iProcessWorkItems = 0;
    List<String> unprocessedIDs = null;

    @Override
    public ItemCollection loadConfiguration() {
        ItemCollection configItemCollection = null;
        String sQuery = "SELECT config FROM Entity AS config  JOIN config.textItems AS t2 WHERE config.type = 'configuration' AND t2.itemName = 'txtname' AND t2.itemValue = 'org.imixs.workflow.scheduler' ORDER BY t2.itemValue asc";
        List<ItemCollection> col = this.entityService.findAllEntities(sQuery, 0, 1);
        if (col.size() > 0) {
            configItemCollection = (ItemCollection)col.iterator().next();
        } else {
            configItemCollection = new ItemCollection();
            try {
                configItemCollection.replaceItemValue("type", (Object)TYPE);
                configItemCollection.replaceItemValue("txtname", (Object)NAME);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        configItemCollection = this.updateTimerDetails(configItemCollection);
        return configItemCollection;
    }

    @Override
    public ItemCollection saveConfiguration(ItemCollection configItemCollection) throws AccessDeniedException {
        configItemCollection.replaceItemValue("type", (Object)TYPE);
        configItemCollection.replaceItemValue("txtName", (Object)NAME);
        configItemCollection.replaceItemValue("$writeAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configItemCollection.replaceItemValue("$readAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configItemCollection = this.updateTimerDetails(configItemCollection);
        configItemCollection = this.entityService.save(configItemCollection);
        return configItemCollection;
    }

    @Override
    public ItemCollection start() throws AccessDeniedException, ParseException {
        ItemCollection configItemCollection = this.loadConfiguration();
        Timer timer = null;
        if (configItemCollection == null) {
            return null;
        }
        String id = configItemCollection.getItemValueString("$uniqueid");
        while (this.findTimer(id) != null) {
            this.findTimer(id).cancel();
        }
        String sConfiguation = configItemCollection.getItemValueString("txtConfiguration");
        if (!sConfiguation.isEmpty()) {
            timer = this.createTimerOnCalendar(configItemCollection);
        } else {
            int hours = configItemCollection.getItemValueInteger("hours");
            int minutes = configItemCollection.getItemValueInteger("minutes");
            long interval = (hours * 60 + minutes) * 60 * 1000;
            configItemCollection.replaceItemValue("numInterval", (Object)new Long(interval));
            timer = this.createTimerOnInterval(configItemCollection);
        }
        if (timer != null) {
            Calendar calNow = Calendar.getInstance();
            SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
            String msg = "started at " + dateFormatDE.format(calNow.getTime()) + " by " + this.ctx.getCallerPrincipal().getName();
            configItemCollection.replaceItemValue("statusmessage", (Object)msg);
            if (timer.isCalendarTimer()) {
                configItemCollection.replaceItemValue("Schedule", (Object)timer.getSchedule().toString());
            } else {
                configItemCollection.replaceItemValue("Schedule", (Object)"");
            }
            logger.info("[WorkflowSchedulerService] " + configItemCollection.getItemValueString("txtName") + " started: " + id);
        }
        configItemCollection = this.saveConfiguration(configItemCollection);
        return configItemCollection;
    }

    @Override
    public ItemCollection stop() throws AccessDeniedException {
        ItemCollection configItemCollection = this.loadConfiguration();
        String id = configItemCollection.getItemValueString("$uniqueid");
        boolean found = false;
        while (this.findTimer(id) != null) {
            this.findTimer(id).cancel();
            found = true;
        }
        if (found) {
            Calendar calNow = Calendar.getInstance();
            SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
            String msg = "stopped at " + dateFormatDE.format(calNow.getTime()) + " by " + this.ctx.getCallerPrincipal().getName();
            configItemCollection.replaceItemValue("statusmessage", (Object)msg);
            logger.info("[WorkflowSchedulerService] " + configItemCollection.getItemValueString("txtName") + " stopped: " + id);
        } else {
            configItemCollection.replaceItemValue("statusmessage", (Object)"");
        }
        configItemCollection = this.saveConfiguration(configItemCollection);
        return configItemCollection;
    }

    @Override
    public boolean isRunning() {
        try {
            ItemCollection configItemCollection = this.loadConfiguration();
            if (configItemCollection == null) {
                return false;
            }
            return this.findTimer(configItemCollection.getItemValueString("$uniqueid")) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean workItemInDue(ItemCollection doc, ItemCollection docActivity) {
        try {
            int iCompareType = -1;
            int iDelayUnit = -1;
            Date dateTimeCompare = null;
            int iActivityDelay = 0;
            String suniqueid = doc.getItemValueString("$uniqueid");
            String sDelayUnit = docActivity.getItemValueString("keyActivityDelayUnit");
            try {
                iDelayUnit = Integer.parseInt(sDelayUnit);
            }
            catch (NumberFormatException nfe) {
                logger.warning("[WorkflowSchedulerService] error parsing delay in ActivityEntity " + docActivity.getItemValueInteger("numProcessID") + "." + docActivity.getItemValueInteger("numActivityID") + " :" + nfe.getMessage());
                return false;
            }
            iActivityDelay = docActivity.getItemValueInteger("numActivityDelay");
            if ("1".equals(sDelayUnit)) {
                sDelayUnit = "minutes";
            }
            if ("2".equals(sDelayUnit)) {
                sDelayUnit = "hours";
            }
            if ("3".equals(sDelayUnit)) {
                sDelayUnit = "days";
            }
            logger.finest("[WorkflowSchedulerService] " + suniqueid + " delay =" + iActivityDelay + " " + sDelayUnit);
            if (iDelayUnit == 1) {
                iActivityDelay *= 60;
            } else if (iDelayUnit == 2) {
                iActivityDelay *= 3600;
            } else if (iDelayUnit == 3) {
                iActivityDelay *= 86400;
            }
            iCompareType = Integer.parseInt(docActivity.getItemValueString("keyScheduledBaseObject"));
            Date dateTimeNow = Calendar.getInstance().getTime();
            switch (iCompareType) {
                case 1: {
                    logger.finest("[WorkflowSchedulerService] " + suniqueid + ": CompareType = last process");
                    if (!doc.hasItem("timWorkflowLastAccess")) {
                        return false;
                    }
                    dateTimeCompare = doc.getItemValueDate("timWorkflowLastAccess");
                    logger.finest("[WorkflowSchedulerService] " + suniqueid + ": timWorkflowLastAccess=" + dateTimeCompare);
                    dateTimeCompare = WorkflowSchedulerService.adjustSecond(dateTimeCompare, iActivityDelay);
                    return dateTimeCompare.before(dateTimeNow);
                }
                case 2: {
                    logger.finest("[WorkflowSchedulerService] " + suniqueid + ": CompareType = last modify");
                    dateTimeCompare = doc.getItemValueDate("$modified");
                    logger.finest("[WorkflowSchedulerService] " + suniqueid + ": modified=" + dateTimeCompare);
                    dateTimeCompare = WorkflowSchedulerService.adjustSecond(dateTimeCompare, iActivityDelay);
                    return dateTimeCompare.before(dateTimeNow);
                }
                case 3: {
                    logger.finest("[WorkflowSchedulerService] " + suniqueid + ": CompareType = creation");
                    dateTimeCompare = doc.getItemValueDate("$created");
                    logger.fine("[WorkflowSchedulerService] " + suniqueid + ": doc.getCreated() =" + dateTimeCompare);
                    dateTimeCompare = WorkflowSchedulerService.adjustSecond(dateTimeCompare, iActivityDelay);
                    return dateTimeCompare.before(dateTimeNow);
                }
                case 4: {
                    String sNameOfField = docActivity.getItemValueString("keyTimeCompareField");
                    logger.finest("[WorkflowSchedulerService] " + suniqueid + ": CompareType = field: '" + sNameOfField + "'");
                    if (!doc.hasItem(sNameOfField)) {
                        logger.finest("[WorkflowSchedulerService] " + suniqueid + ": CompareType =" + sNameOfField + " no value found!");
                        return false;
                    }
                    dateTimeCompare = doc.getItemValueDate(sNameOfField);
                    logger.finest("[WorkflowSchedulerService] " + suniqueid + ": " + sNameOfField + "=" + dateTimeCompare);
                    dateTimeCompare = WorkflowSchedulerService.adjustSecond(dateTimeCompare, iActivityDelay);
                    logger.finest("[WorkflowSchedulerService] " + suniqueid + ": Compare " + dateTimeCompare + " <-> " + dateTimeNow);
                    if (dateTimeCompare.before(dateTimeNow)) {
                        logger.finest("[WorkflowSchedulerService] " + suniqueid + " isInDue!");
                    }
                    return dateTimeCompare.before(dateTimeNow);
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Timeout
    void runTimer(Timer timer) throws AccessDeniedException {
        ItemCollection configItemCollection;
        block9: {
            configItemCollection = this.loadConfiguration();
            logger.info("[WorkflowSchedulerService] started....");
            if (!this.isImixsDayOfWeek(configItemCollection)) {
                logger.info("[WorkflowSchedulerService] runTimer skipped because today is no imixsDayOfWeek");
                return;
            }
            configItemCollection.replaceItemValue("datLastRun", (Object)new Date());
            this.iProcessWorkItems = 0;
            this.unprocessedIDs = new ArrayList<String>();
            try {
                List<String> modelVersions = this.modelService.getAllModelVersions();
                for (String version : modelVersions) {
                    logger.info("[WorkflowSchedulerService] processing ModelVersion: " + version);
                    Collection<ItemCollection> colScheduledActivities = this.findScheduledActivities(version);
                    logger.info("[WorkflowSchedulerService] " + colScheduledActivities.size() + " scheduled activityEntities found in ModelVersion: " + version);
                    for (ItemCollection aactivityEntity : colScheduledActivities) {
                        this.processWorkListByActivityEntity(aactivityEntity);
                    }
                }
            }
            catch (Exception e) {
                logger.severe("[WorkflowSchedulerService] error processing worklist: " + e.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block9;
                e.printStackTrace();
            }
        }
        logger.info("[WorkflowSchedulerService] finished successfull");
        logger.info("[WorkflowSchedulerService] " + this.iProcessWorkItems + " workitems processed");
        if (this.unprocessedIDs.size() > 0) {
            logger.warning("[WorkflowSchedulerService] " + this.unprocessedIDs.size() + " workitems could be processed!");
            for (String aid : this.unprocessedIDs) {
                logger.warning("[WorkflowSchedulerService]          " + aid);
            }
        }
        Date endDate = configItemCollection.getItemValueDate("datstop");
        String sTimerID = configItemCollection.getItemValueString("$uniqueid");
        configItemCollection.replaceItemValue("numWorkItemsProcessed", (Object)this.iProcessWorkItems);
        configItemCollection.replaceItemValue("numWorkItemsUnprocessed", (Object)this.unprocessedIDs.size());
        String sConfiguation = configItemCollection.getItemValueString("txtConfiguration");
        if (sConfiguation.isEmpty()) {
            Calendar calNow = Calendar.getInstance();
            if (endDate != null && calNow.getTime().after(endDate)) {
                timer.cancel();
                System.out.println("[WorkflowSchedulerService] Timeout sevice stopped: " + sTimerID);
                SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
                String msg = "stopped at " + dateFormatDE.format(calNow.getTime()) + " by datstop=" + dateFormatDE.format(endDate);
                configItemCollection.replaceItemValue("statusmessage", (Object)msg);
            }
        }
        configItemCollection = this.saveConfiguration(configItemCollection);
    }

    Timer createTimerOnInterval(ItemCollection configItemCollection) {
        Date startDate = configItemCollection.getItemValueDate("datstart");
        Date endDate = configItemCollection.getItemValueDate("datstop");
        long interval = configItemCollection.getItemValueInteger("numInterval");
        Calendar calNow = Calendar.getInstance();
        Calendar calEnd = Calendar.getInstance();
        if (endDate != null) {
            calEnd.setTime(endDate);
        }
        if (calNow.after(calEnd)) {
            logger.warning("[WorkflowSchedulerService] " + configItemCollection.getItemValueString("txtName") + " stop-date is in the past");
            endDate = startDate;
        }
        Timer timer = this.timerService.createTimer(startDate, interval, (Serializable)configItemCollection);
        return timer;
    }

    Timer createTimerOnCalendar(ItemCollection configItemCollection) throws ParseException {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)configItemCollection);
        ScheduleExpression scheduerExpression = new ScheduleExpression();
        List calendarConfiguation = configItemCollection.getItemValue("txtConfiguration");
        for (String confgEntry : calendarConfiguation) {
            Date convertedDate;
            SimpleDateFormat dateFormat;
            if (confgEntry.startsWith("second=")) {
                scheduerExpression.second(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("minute=")) {
                scheduerExpression.minute(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("hour=")) {
                scheduerExpression.hour(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfWeek=")) {
                scheduerExpression.dayOfWeek(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfMonth=")) {
                scheduerExpression.dayOfMonth(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("month=")) {
                scheduerExpression.month(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("year=")) {
                scheduerExpression.year(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("timezone=")) {
                scheduerExpression.timezone(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("start=")) {
                dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
                scheduerExpression.start(convertedDate);
            }
            if (!confgEntry.startsWith("end=")) continue;
            dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
            scheduerExpression.end(convertedDate);
        }
        Timer timer = this.timerService.createCalendarTimer(scheduerExpression, timerConfig);
        return timer;
    }

    Collection<ItemCollection> findScheduledActivities(String aModelVersion) throws Exception {
        Vector<ItemCollection> vectorActivities = new Vector<ItemCollection>();
        Collection colProcessList = null;
        colProcessList = aModelVersion != null ? this.modelService.getProcessEntityListByVersion(aModelVersion) : this.modelService.getProcessEntityList();
        for (ItemCollection aprocessentity : colProcessList) {
            int processid = aprocessentity.getItemValueInteger("numprocessid");
            Collection aActivityList = this.modelService.getActivityEntityListByVersion(processid, aModelVersion);
            for (ItemCollection aactivityEntity : aActivityList) {
                if (!"1".equals(aactivityEntity.getItemValueString("keyScheduledActivity"))) continue;
                vectorActivities.add(aactivityEntity);
            }
        }
        return vectorActivities;
    }

    Timer findTimer(String id) {
        Timer timer = null;
        for (Object obj : this.timerService.getTimers()) {
            ItemCollection adescription;
            Timer atimer = (Timer)obj;
            if (!(atimer.getInfo() instanceof ItemCollection) || !id.equals((adescription = (ItemCollection)atimer.getInfo()).getItemValueString("$uniqueid"))) continue;
            if (timer != null) {
                logger.severe("[WorkflowScheduelrService] - more then one timer with id " + id + " was found!");
            }
            timer = atimer;
        }
        return timer;
    }

    void processWorkListByActivityEntity(ItemCollection activityEntity) throws Exception {
        int iProcessID = activityEntity.getItemValueInteger("numprocessid");
        int iActivityID = activityEntity.getItemValueInteger("numActivityID");
        String sModelVersion = activityEntity.getItemValueString("$modelversion");
        logger.info("[WorkflowSchedulerService] processing " + iProcessID + "." + iActivityID + " (" + sModelVersion + ") ...");
        String sQuery = "SELECT wi FROM Entity as wi  JOIN wi.integerItems AS i  JOIN wi.textItems as t  WHERE wi.type='workitem' ";
        sQuery = sQuery + " AND i.itemName = '$processid' AND i.itemValue = '" + iProcessID + "'" + " AND t.itemName = '$modelversion' AND t.itemValue = '" + sModelVersion + "'";
        logger.fine("[WorkflowSchedulerService] select: " + sQuery);
        List<ItemCollection> worklist = this.entityService.findAllEntities(sQuery, 0, -1);
        logger.fine("[WorkflowSchedulerService] " + worklist.size() + " workitems found");
        for (ItemCollection workitem : worklist) {
            if (!WorkflowSchedulerService.workItemInDue(workitem, activityEntity)) continue;
            String sID = workitem.getItemValueString("$uniqueid");
            logger.fine("[WorkflowSchedulerService] workitem " + sID + "is in due");
            workitem.replaceItemValue("$activityid", (Object)iActivityID);
            try {
                logger.finest("[WorkflowSchedulerService] getBusinessObject.....");
                ((WorkflowSchedulerService)this.ctx.getBusinessObject(WorkflowSchedulerService.class)).processSingleWorkitem(workitem);
                ++this.iProcessWorkItems;
            }
            catch (Exception e) {
                logger.warning("[WorkflowSchedulerService] error processing workitem: " + sID);
                if (logger.isLoggable(Level.FINEST)) {
                    e.printStackTrace();
                }
                this.unprocessedIDs.add(sID);
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void processSingleWorkitem(ItemCollection aWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException {
        this.workflowService.processWorkItem(aWorkitem);
    }

    private ItemCollection updateTimerDetails(ItemCollection configuration) {
        if (configuration == null) {
            return configuration;
        }
        String id = configuration.getItemValueString("$uniqueid");
        try {
            Timer timer = this.findTimer(id);
            if (timer != null) {
                configuration.replaceItemValue("nextTimeout", (Object)timer.getNextTimeout());
                configuration.replaceItemValue("timeRemaining", (Object)timer.getTimeRemaining());
            } else {
                configuration.removeItem("nextTimeout");
                configuration.removeItem("timeRemaining");
            }
        }
        catch (Exception e) {
            logger.warning("[WorkflowSchedulerService] unable to updateTimerDetails: " + e.getMessage());
            configuration.removeItem("nextTimeout");
            configuration.removeItem("timeRemaining");
        }
        return configuration;
    }

    private boolean isImixsDayOfWeek(ItemCollection configItemCollection) {
        List calendarConfiguation = configItemCollection.getItemValue("txtConfiguration");
        for (String confgEntry : calendarConfiguation) {
            if (!confgEntry.startsWith("imixsDayOfWeek=")) continue;
            logger.info("[WorkflowSchedulerService] " + confgEntry);
            try {
                String dayValue = confgEntry.substring(confgEntry.indexOf(61) + 1);
                int iStartDay = 0;
                int iEndDay = 0;
                int iSeparator = dayValue.indexOf(45);
                if (iSeparator > -1) {
                    iStartDay = Integer.valueOf(dayValue.substring(0, iSeparator));
                    iEndDay = Integer.valueOf(dayValue.substring(iSeparator + 1));
                } else {
                    iEndDay = iStartDay = Integer.valueOf(dayValue).intValue();
                }
                Calendar now = Calendar.getInstance();
                now.setTime(new Date());
                int iDay = now.get(7);
                if (--iDay < iStartDay || iDay > iEndDay) {
                    logger.info("[WorkflowSchedulerService] imixsDayOfWeek=false");
                    return false;
                }
                logger.info("[WorkflowSchedulerService] imixsDayOfWeek=true");
                return true;
            }
            catch (Exception e) {
                logger.warning("[WorkflowSchedulerService] imixsDayOfWeek not parseable!");
            }
        }
        return true;
    }

    private static Date adjustSecond(Date adate, int seconds) {
        Calendar calTimeCompare = Calendar.getInstance();
        calTimeCompare.setTime(adate);
        calTimeCompare.add(13, seconds);
        return calTimeCompare.getTime();
    }
}

