/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.team.TeamController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.ViewController;
import org.imixs.workflow.faces.util.LoginController;
import org.imixs.workflow.office.config.SetupController;
import org.imixs.workflow.office.model.ModelController;
import org.imixs.workflow.office.views.SearchEvent;

@Named
@SessionScoped
public class SearchController
extends ViewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(SearchController.class.getName());
    ItemCollection searchFilter = null;
    @Inject
    SetupController setupController;
    @Inject
    TeamController processController;
    @Inject
    LoginController loginController;
    @Inject
    ModelController modelController;
    @EJB
    SchemaService schemaService;
    @Inject
    DocumentService documentService;
    @Inject
    protected Event<SearchEvent> searchEvents;
    @Inject
    @ConfigProperty(name="office.search.noanalyze", defaultValue="undefined")
    transient String officeSearchNoanalyse;
    @Inject
    @ConfigProperty(name="office.search.pagesize", defaultValue="10")
    transient int officeSearchSize;
    ItemCollection process;
    ItemCollection space;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        String phrase;
        String workflowgroup;
        String participant;
        String creator;
        String owner;
        String spaceRef;
        FacesContext fc;
        Map paramMap;
        String processRef;
        this.setSortBy(this.setupController.getSortBy());
        this.setSortReverse(this.setupController.getSortReverse());
        this.setPageSize(this.officeSearchSize);
        this.setPageIndex(this.getPageIndex());
        if (this.searchFilter == null) {
            this.reset();
        }
        if ((processRef = (String)(paramMap = (fc = FacesContext.getCurrentInstance()).getExternalContext().getRequestParameterMap()).get("processref")) != null && !processRef.isEmpty()) {
            this.searchFilter.replaceItemValue("processref", (Object)processRef);
        }
        if ("true".equals(paramMap.get("archive"))) {
            this.searchFilter.replaceItemValue("type", (Object)"workitemarchive");
        }
        if ((spaceRef = (String)paramMap.get("spaceref")) != null && !spaceRef.isEmpty()) {
            this.searchFilter.replaceItemValue("spaceref", (Object)spaceRef);
        }
        if ((owner = (String)paramMap.get("owner")) != null && !owner.isEmpty()) {
            this.searchFilter.replaceItemValue("user", (Object)owner);
            this.searchFilter.replaceItemValue("usermode", (Object)"owner");
        }
        if ((creator = (String)paramMap.get("creator")) != null && !creator.isEmpty()) {
            this.searchFilter.replaceItemValue("user", (Object)creator);
            this.searchFilter.replaceItemValue("usermode", (Object)"creator");
        }
        if ((participant = (String)paramMap.get("participant")) != null && !participant.isEmpty()) {
            this.searchFilter.replaceItemValue("user", (Object)participant);
            this.searchFilter.replaceItemValue("usermode", (Object)"participant");
        }
        if ((workflowgroup = (String)paramMap.get("workflowgroup")) != null && !workflowgroup.isEmpty()) {
            this.searchFilter.replaceItemValue("$WorkflowGroup", (Object)workflowgroup);
            String task = (String)paramMap.get("task");
            if (task != null && !task.isEmpty()) {
                int taskID = 0;
                try {
                    taskID = Integer.parseInt(task);
                }
                catch (NumberFormatException nfe) {
                    Model model = this.modelController.getModelByGroup(workflowgroup);
                    List tasks = model.findTasksByGroup(workflowgroup);
                    for (ItemCollection taskElement : tasks) {
                        if (!task.equals(taskElement.getItemValueString("txtname"))) continue;
                        taskID = taskElement.getItemValueInteger("numProcessID");
                        break;
                    }
                }
                if (taskID > 0) {
                    this.searchFilter.replaceItemValue("$taskid", (Object)taskID);
                }
            }
        }
        if ((phrase = (String)paramMap.get("phrase")) != null && !phrase.isEmpty()) {
            this.searchFilter.replaceItemValue("phrase", (Object)phrase);
        }
        this.process = this.processController.getEntityById(this.searchFilter.getItemValueString("processref"));
        this.space = this.processController.getEntityById(this.searchFilter.getItemValueString("spaceref"));
    }

    public String getSortBy() {
        if ("1".equals(this.getSearchFilter().getItemValueString("sortorder")) || "2".equals(this.getSearchFilter().getItemValueString("sortorder"))) {
            return "$lasteventdate";
        }
        return super.getSortBy();
    }

    public boolean isSortReverse() {
        if ("2".equals(this.getSearchFilter().getItemValueString("sortorder"))) {
            return false;
        }
        if ("1".equals(this.getSearchFilter().getItemValueString("sortorder"))) {
            return true;
        }
        return super.isSortReverse();
    }

    public ItemCollection getProcess() {
        return this.process;
    }

    public ItemCollection getSpace() {
        return this.space;
    }

    public void reset() {
        this.searchFilter = new ItemCollection();
        this.searchFilter.replaceItemValue("type", (Object)"workitem");
        this.searchFilter.replaceItemValue("usermode", (Object)"owner");
        this.setPageIndex(0);
        super.reset();
    }

    public String resetFilter() {
        String searchPhrase = this.searchFilter.getItemValueString("phrase");
        this.reset();
        this.searchFilter.replaceItemValue("phrase", (Object)searchPhrase);
        return this.refreshSearch();
    }

    public String resetSearch() {
        this.reset();
        return this.refreshSearch();
    }

    public String refreshSearch() {
        String phrase = this.searchFilter.getItemValueString("phrase");
        try {
            phrase = URLEncoder.encode(phrase, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("unable to encode search phrase!");
            e.printStackTrace();
        }
        String action = "/pages/workitems/worklist.xhtml?faces-redirect=true&phrase=" + phrase;
        this.setPageIndex(0);
        return action;
    }

    public String refreshSearch(AjaxBehaviorEvent event) {
        return this.refreshSearch();
    }

    public ItemCollection getSearchFilter() {
        if (this.searchFilter == null) {
            this.reset();
        }
        return this.searchFilter;
    }

    public void setSearchFilter(ItemCollection searchFilter) {
        this.searchFilter = searchFilter;
    }

    public void setDMSMode(boolean dms) {
        this.searchFilter.replaceItemValue("dms_search", (Object)dms);
    }

    public String getQuery() {
        String searchphrase;
        Calendar cal;
        String query = "";
        String emptySearchTerm = "";
        List processIDs = this.searchFilter.getItemValue("$taskID");
        List processRefList = this.searchFilter.getItemValue("ProcessRef");
        List spacesRefList = this.searchFilter.getItemValue("SpaceRef");
        List workflowGroups = this.searchFilter.getItemValue("$WorkflowGroup");
        while (processIDs.contains("")) {
            processIDs.remove("");
        }
        while (processRefList.contains("")) {
            processRefList.remove("");
        }
        while (spacesRefList.contains("")) {
            spacesRefList.remove("");
        }
        while (workflowGroups.contains("")) {
            workflowGroups.remove("");
        }
        while (processRefList.contains("-")) {
            processRefList.remove("-");
        }
        while (spacesRefList.contains("-")) {
            spacesRefList.remove("-");
        }
        List<String> typeList = this.searchFilter.getItemValue("Type");
        if (typeList.isEmpty() || "".equals(typeList.get(0))) {
            typeList = Arrays.asList("workitem");
        }
        String sTypeQuery = "";
        Iterator<String> iterator = typeList.iterator();
        while (iterator.hasNext()) {
            sTypeQuery = sTypeQuery + "type:\"" + iterator.next() + "\"";
            if (!iterator.hasNext()) continue;
            sTypeQuery = sTypeQuery + " OR ";
        }
        emptySearchTerm = query = query + "(" + sTypeQuery + ") AND";
        if ("true".equals(this.searchFilter.getItemValueString("dms_search"))) {
            query = query + " ($file.count:[1 TO 999]) AND";
        }
        Date datFrom = this.searchFilter.getItemValueDate("date.From");
        Date datTo = this.searchFilter.getItemValueDate("date.To");
        if (!processRefList.isEmpty()) {
            query = query + " (";
            iterator = processRefList.iterator();
            while (iterator.hasNext()) {
                query = query + "$uniqueidref:\"" + iterator.next() + "\"";
                if (!iterator.hasNext()) continue;
                query = query + " OR ";
            }
            query = query + " ) AND";
        }
        if (!spacesRefList.isEmpty()) {
            query = query + " (";
            iterator = spacesRefList.iterator();
            while (iterator.hasNext()) {
                query = query + "$uniqueidref:\"" + iterator.next() + "\"";
                if (!iterator.hasNext()) continue;
                query = query + " OR ";
            }
            query = query + " ) AND";
        }
        if (!workflowGroups.isEmpty()) {
            query = query + " (";
            iterator = workflowGroups.iterator();
            while (iterator.hasNext()) {
                query = query + "txtworkflowgroup:\"" + iterator.next() + "\"";
                if (!iterator.hasNext()) continue;
                query = query + " OR ";
            }
            query = query + " ) AND";
        }
        String sDateFrom = "191401070000";
        String sDateTo = "211401070000";
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
        if (datFrom != null) {
            cal = Calendar.getInstance();
            cal.setTime(datFrom);
            sDateFrom = dateformat.format(cal.getTime());
        }
        if (datTo != null) {
            cal = Calendar.getInstance();
            cal.setTime(datTo);
            cal.add(5, 1);
            sDateTo = dateformat.format(cal.getTime());
        }
        if (datFrom != null || datTo != null) {
            query = query + " ($created:[" + sDateFrom + " TO " + sDateTo + "]) AND";
        }
        String sUser = this.getSearchFilter().getItemValueString("user");
        String sUserMode = this.getSearchFilter().getItemValueString("usermode");
        if (!"".equals(sUser)) {
            query = "creator".equals(sUserMode) ? query + " ($creator:\"" + sUser.toLowerCase() + "\") AND" : ("participant".equals(sUserMode) ? query + " ($participants:\"" + sUser.toLowerCase() + "\") AND" : query + " ($owner:\"" + sUser.toLowerCase() + "\") AND");
        }
        if (!processIDs.isEmpty()) {
            query = query + " (";
            Iterator iteratorID = processIDs.iterator();
            while (iteratorID.hasNext()) {
                query = query + "$taskid:\"" + iteratorID.next() + "\"";
                if (!iteratorID.hasNext()) continue;
                query = query + " OR ";
            }
            query = query + " ) AND";
        }
        if (this.searchEvents != null) {
            SearchEvent event = new SearchEvent(this.searchFilter, 1);
            this.searchEvents.fire((Object)event);
            String customQuery = event.getQuery();
            if (customQuery != null && !customQuery.isEmpty()) {
                if (!customQuery.trim().endsWith("AND")) {
                    customQuery = customQuery + " AND";
                }
                query = query + customQuery;
            }
        }
        if ((searchphrase = this.searchFilter.getItemValueString("phrase")) != null && !"".equals(searchphrase)) {
            query = query + " (";
            String normalizedSearchphrase = this.schemaService.normalizeSearchTerm(searchphrase);
            if (!"undefined".equals(this.officeSearchNoanalyse) && !searchphrase.equalsIgnoreCase(normalizedSearchphrase)) {
                String[] officeFields = this.officeSearchNoanalyse.split(",");
                query = query + " (";
                Iterator<String> itemIterator = Arrays.asList(officeFields).iterator();
                while (itemIterator.hasNext()) {
                    String itemName = itemIterator.next();
                    if (!this.schemaService.getFieldListNoAnalyze().contains(itemName)) {
                        throw new InvalidAccessException("SEARCH_ERROR", "office.search.noanalyze contains the item '" + itemName + "' which is not listed in 'index.fields.noanalyze'!");
                    }
                    query = query + itemName + ":\"" + searchphrase.trim() + "\" ";
                    if (!itemIterator.hasNext()) continue;
                    query = query + " OR ";
                }
                query = query + ") OR ";
            }
            query = query + "(" + normalizedSearchphrase.trim() + ") ";
            query = query + ")";
            this.setSortBy(null);
            this.setSortReverse(false);
        } else {
            this.setSortBy(this.setupController.getSortBy());
            this.setSortReverse(this.setupController.getSortReverse());
        }
        if (query.equals(emptySearchTerm)) {
            query = null;
        }
        if (query != null && query.endsWith("AND")) {
            query = query.substring(0, query.length() - 3);
        }
        logger.fine("Search Query=" + query);
        return query;
    }

    public long getCount() {
        long result = 0L;
        try {
            result = this.documentService.count(this.getQuery());
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
        return result;
    }
}

