/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.util;

import java.util.logging.Logger;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;

public class SessionExpirationPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(SessionExpirationPhaseListener.class.getName());

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent event) {
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest httpRequest = (HttpServletRequest)context.getExternalContext().getRequest();
        if (httpRequest.getRequestedSessionId() != null && !httpRequest.isRequestedSessionIdValid()) {
            boolean isAjaxRequest;
            String facesRequestHeader = httpRequest.getHeader("Faces-Request");
            boolean bl = isAjaxRequest = facesRequestHeader != null && facesRequestHeader.equals("partial/ajax");
            if (isAjaxRequest) {
                logger.finest("...ajax session expired!");
                ConfigurableNavigationHandler handler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
                handler.performNavigation("sessionexpired");
            }
        }
    }
}

