/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.util;

import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentEvent;

@Stateless
@LocalBean
public class ItemMigrationService {
    public void onDocumentEvent(@Observes DocumentEvent documentEvent) {
        String type = documentEvent.getDocument().getType();
        if (type.startsWith("space") && documentEvent.getEventType() == 2) {
            this.migrate(documentEvent.getDocument(), "nammanager", "space.manager");
            this.migrate(documentEvent.getDocument(), "namteam", "space.team");
            this.migrate(documentEvent.getDocument(), "namassist", "space.assist");
            this.migrate(documentEvent.getDocument(), "txtname", "name");
            this.migrate(documentEvent.getDocument(), "txtspacename", "space.name");
            this.migrate(documentEvent.getDocument(), "txtspaceref", "space.ref");
        }
        if (type.startsWith("process") && documentEvent.getEventType() == 2) {
            this.migrate(documentEvent.getDocument(), "nammanager", "process.manager");
            this.migrate(documentEvent.getDocument(), "namteam", "process.team");
            this.migrate(documentEvent.getDocument(), "namassist", "process.assist");
            this.migrate(documentEvent.getDocument(), "txtname", "name");
            this.migrate(documentEvent.getDocument(), "txtprocessref", "process.ref");
        }
    }

    private void migrate(ItemCollection document, String oldItem, String newItem) {
        if (document.hasItem(newItem)) {
            return;
        }
        document.replaceItemValue(newItem, (Object)document.getItemValue(oldItem));
    }
}

