/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.rest;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.imixs.archive.core.api.SnapshotRestService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.office.config.TextBlockService;

@Named
@RequestScoped
@Path(value="/textblock")
@Produces(value={"text/html", "application/xhtml+xml", "text/plain"})
public class TextblockRestService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(TextblockRestService.class.getSimpleName());
    @EJB
    DocumentService entityService;
    @Inject
    TextBlockService textBlockService;
    @Inject
    SnapshotRestService snapshotRestService;

    @GET
    @Path(value="/{name}/html")
    @Produces(value={"text/html"})
    public Response getTextBlock(@PathParam(value="name") String name) {
        ItemCollection textBlock = this.textBlockService.loadTextBlock(name);
        if (textBlock != null) {
            return Response.ok((Object)textBlock.getItemValueString("txtcontent")).build();
        }
        return Response.ok((Object)"Not Found").status(Response.Status.NOT_ACCEPTABLE).build();
    }

    @GET
    @Path(value="/{name}/htmlpage")
    @Produces(value={"text/html"})
    public Response getTextBlockAsPage(@PathParam(value="name") String name) {
        ItemCollection textBlock = this.textBlockService.loadTextBlock(name);
        if (textBlock != null) {
            try {
                return Response.temporaryRedirect((URI)new URI("../pages/textbock.xhtml?id=" + textBlock.getUniqueID())).build();
            }
            catch (URISyntaxException e) {
                return Response.ok((Object)"Not Found").status(Response.Status.NOT_ACCEPTABLE).build();
            }
        }
        return Response.ok((Object)"Not Found").status(Response.Status.NOT_ACCEPTABLE).build();
    }

    @GET
    @Path(value="/{name}/text")
    @Produces(value={"text/plain"})
    public Response getTextBlockPlain(@PathParam(value="name") String name) {
        ItemCollection textBlock = this.textBlockService.loadTextBlock(name);
        if (textBlock != null) {
            return Response.ok((Object)textBlock.getItemValueString("txtcontent")).build();
        }
        return Response.ok((Object)"Not Found").status(Response.Status.NOT_ACCEPTABLE).build();
    }

    @GET
    @Path(value="/{name}/file/{file}")
    @Produces(value={"text/plain"})
    public Response getTextblockFile(@PathParam(value="name") String name, @PathParam(value="file") @Encoded String file, @Context UriInfo uriInfo) {
        ItemCollection textBlock = this.textBlockService.loadTextBlock(name);
        return this.snapshotRestService.getWorkItemFile(textBlock.getUniqueID(), file, uriInfo);
    }
}

