/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.model;

import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.faces.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.ParserConfigurationException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.bpmn.BPMNParser;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.SetupService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.office.model.ModelUploadHandler;
import org.xml.sax.SAXException;

@Named
@RequestScoped
public class ModelController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    protected ModelUploadHandler modelUploadHandler;
    @EJB
    protected ModelService modelService;
    @EJB
    protected WorkflowService workflowService;
    @EJB
    protected SetupService setupService;
    private Map<String, ItemCollection> modelEntityCache = new HashMap<String, ItemCollection>();
    private static Logger logger = Logger.getLogger(ModelController.class.getName());

    public List<String> getGroups(String version) {
        try {
            return this.modelService.getModel(version).getGroups();
        }
        catch (ModelException e) {
            logger.warning("Unable to load groups:" + e.getMessage());
            return new ArrayList<String>();
        }
    }

    public List<String> getWorkflowGroups() {
        HashSet set = new HashSet();
        List versions = this.modelService.getVersions();
        for (String version : versions) {
            try {
                if (version.startsWith("system-")) continue;
                set.addAll(this.modelService.getModel(version).getGroups());
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String agroup : set) {
            if (result.contains(agroup) || agroup.contains("~")) continue;
            result.add(agroup);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getSubWorkflowGroups(String parentWorkflowGroup) {
        HashSet set = new HashSet();
        List versions = this.modelService.getVersions();
        for (String version : versions) {
            try {
                if (version.startsWith("system-")) continue;
                set.addAll(this.modelService.getModel(version).getGroups());
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String agroup : set) {
            if (result.contains(agroup) || !agroup.startsWith(parentWorkflowGroup + "~")) continue;
            result.add(agroup);
        }
        Collections.sort(result);
        return result;
    }

    public Model getModelByWorkitem(ItemCollection workitem) {
        try {
            return this.modelService.getModelByWorkitem(workitem);
        }
        catch (ModelException e) {
            return null;
        }
    }

    public Model getModelByGroup(String group) {
        List versions = this.modelService.findVersionsByGroup(group);
        if (!versions.isEmpty()) {
            String version = (String)versions.get(0);
            try {
                return this.modelService.getModel(version);
            }
            catch (ModelException e) {
                logger.warning(e.getMessage());
                return null;
            }
        }
        return null;
    }

    public List<String> getVersions() {
        List list = this.modelService.getVersions();
        Collections.sort(list);
        return list;
    }

    public ItemCollection getModelEntity(String version) {
        ItemCollection result = this.modelEntityCache.get(version);
        if (result == null) {
            result = this.modelService.loadModelEntity(version);
            this.modelEntityCache.put(version, result);
        }
        return result;
    }

    public void doUploadModel(ActionEvent event) throws ModelException, ParseException, ParserConfigurationException, SAXException, IOException {
        List fileList = this.modelUploadHandler.getModelUploads().getFileData();
        if (fileList == null) {
            return;
        }
        for (FileData file : fileList) {
            logger.info("Import bpmn-model: " + file.getName());
            if (file.getName().endsWith(".bpmn")) {
                BPMNModel model = BPMNParser.parseModel((byte[])file.getContent(), (String)"UTF-8");
                this.modelService.saveModel(model);
                continue;
            }
            if (file.getName().endsWith(".ixm")) {
                this.setupService.importXmlEntityData(file.getContent());
                continue;
            }
            logger.warning("Invalid Model Type. Model can't be imported!");
        }
        this.modelUploadHandler.reset();
    }

    public void deleteModel(String modelversion) throws AccessDeniedException, ModelException {
        this.modelService.deleteModel(modelversion);
    }

    public ItemCollection getProcessEntity(int processid, String modelversion) {
        try {
            return this.modelService.getModel(modelversion).getTask(processid);
        }
        catch (ModelException e) {
            logger.warning("Unable to load task " + processid + " in model version '" + modelversion + "' - " + e.getMessage());
            return null;
        }
    }

    public String getProcessDescription(int processid, String modelversion, ItemCollection documentContext) {
        ItemCollection pe = null;
        try {
            pe = this.modelService.getModel(modelversion).getTask(processid);
        }
        catch (ModelException e1) {
            logger.warning("Unable to load task " + processid + " in model version '" + modelversion + "' - " + e1.getMessage());
        }
        if (pe == null) {
            return "";
        }
        String desc = pe.getItemValueString("documentation");
        try {
            desc = this.workflowService.adaptText(desc, documentContext);
        }
        catch (PluginException e) {
            logger.warning("Unable to update processDescription: " + e.getMessage());
        }
        return desc;
    }
}

