/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.gdpr;

import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;

public class GDPRErasurePlugin
extends AbstractPlugin {
    private static Logger logger = Logger.getLogger(GDPRErasurePlugin.class.getName());
    public static String PROCESSING_ERROR = "PROCESSING_ERROR";

    public ItemCollection run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(documentActivity, "item", documentContext);
        if (evalItemCollection != null && evalItemCollection.hasItem("gdpr-erasure")) {
            String processDefinition = evalItemCollection.getItemValueString("gdpr-erasure");
            ItemCollection processingData = XMLParser.parseItemStructure((String)processDefinition);
            String anonymizeItemList = processingData.getItemValueString("anonymize");
            String deleteItemList = processingData.getItemValueString("delete");
            String placeholder = processingData.getItemValueString("placeholder");
            if (!anonymizeItemList.isEmpty()) {
                String[] gdprFieldList;
                logger.finest("......anonymizing items for '" + documentContext.getUniqueID() + "'. Placeholder='" + placeholder + "'");
                for (String field : gdprFieldList = anonymizeItemList.split(",")) {
                    logger.finest("......anonymize item: " + field);
                    documentContext.replaceItemValue(field, (Object)placeholder);
                }
            }
            if (!deleteItemList.isEmpty()) {
                String[] dsgvoFieldList;
                logger.finest("......removing items for '" + documentContext.getUniqueID() + "'");
                for (String field : dsgvoFieldList = deleteItemList.split(",")) {
                    logger.finest("......delete item: " + field);
                    documentContext.removeItem(field);
                }
            }
        }
        return documentContext;
    }
}

