/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.util.XMLParser;

@Stateless
public class CountryAdapter {
    private static Logger logger = Logger.getLogger(AbstractPlugin.class.getName());

    public void onEvent(@Observes TextEvent event) {
        String text = event.getText();
        ItemCollection documentContext = event.getDocument();
        List tagList = XMLParser.findTags((String)text, (String)"countryname");
        logger.finest(tagList.size() + " tags found");
        for (String tag : tagList) {
            Locale locale = null;
            String sLocale = XMLParser.findAttribute((String)tag, (String)"locale");
            if (sLocale == null || sLocale.isEmpty()) {
                logger.info("...no locale defined - default to en_EN");
                sLocale = "en_EN";
            }
            String separator = XMLParser.findAttribute((String)tag, (String)"separator");
            if (sLocale != null && !sLocale.isEmpty()) {
                String sLang;
                StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
                if (stLocale.countTokens() == 1) {
                    sLang = stLocale.nextToken();
                    String sCount = sLang.toUpperCase();
                    locale = new Locale(sLang, sCount);
                } else {
                    sLang = stLocale.nextToken();
                    String sCount = stLocale.nextToken();
                    locale = new Locale(sLang, sCount);
                }
            }
            String sItemName = XMLParser.findTagValue((String)tag, (String)"countryname");
            String country = "";
            if (separator == null || separator.isEmpty()) {
                String countryCode = documentContext.getItemValueString(sItemName);
                Locale countryLocale = new Locale("", countryCode);
                if (countryLocale != null) {
                    country = countryLocale.getDisplayCountry(locale);
                }
            } else {
                List countryCodes = documentContext.getItemValue(sItemName);
                for (String countryCode : countryCodes) {
                    Locale countryLocale = new Locale("", countryCode);
                    country = country + countryLocale.getDisplayCountry(locale);
                    country = country + separator;
                }
                if (country.endsWith(separator)) {
                    country = country.substring(0, country.length() - separator.length());
                }
            }
            int iStartPos = text.indexOf(tag);
            int iEndPos = text.indexOf(tag) + tag.length();
            text = text.substring(0, iStartPos) + country + text.substring(iEndPos);
        }
        event.setText(text);
    }
}

