/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.ml.core.MLClient;
import org.imixs.ml.events.EntityObjectEvent;
import org.imixs.ml.training.TrainingDataBuilder;
import org.imixs.ml.xml.XMLTrainingData;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import util.LocaleHelper;

@Stateless
@LocalBean
public class MLService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MLService.class.getName());
    public static final String ITEM_ML_DEFINITIONS = "ml.definitions";
    public static final String ITEM_ML_ENDPOINT = "ml.endpoint";
    public static final String ITEM_ML_ITEMS = "ml.items";
    public static final String ITEM_ML_LOCALES = "ml.locales";
    public static final String ITEM_ML_STATUS = "ml.status";
    public static final String ITEM_ML_MODEL = "ml.model";
    public static final String ITEM_ML_QUALITY = "ml.quality";
    public static final String ML_STATUS_SUGGEST = "suggest";
    public static final String ML_STATUS_CONFIRMED = "confirmed";
    public static final String ML_STATUS_TRAINING = "training";
    public static final String EVENTLOG_TOPIC_TRAINING = "ml.training";
    @Inject
    @ConfigProperty(name="ml.training.scheduler.enabled", defaultValue="false")
    boolean trainingSchedulerEnabled;
    @Inject
    protected Event<EntityObjectEvent> entityObjectEvents;
    @Inject
    protected ModelService modelService;
    @Inject
    protected WorkflowService workflowService;
    @Inject
    protected EventLogService eventLogService;

    public void onWorkflowEvent(@Observes ProcessingEvent processingEvent) {
        if (processingEvent == null) {
            return;
        }
        ItemCollection workitem = processingEvent.getDocument();
        if (workitem != null && !workitem.getItemValueString("type").startsWith("workitem")) {
            return;
        }
        int eventType = processingEvent.getEventType();
        List<ItemCollection> mlDefinitionList = this.getMLDefinitions(workitem);
        boolean bUpdateDefinitions = false;
        for (ItemCollection mlDefinition : mlDefinitionList) {
            List mlItems = mlDefinition.getItemValue(ITEM_ML_ITEMS);
            if (2 == eventType && mlItems.size() > 0 && mlDefinition.getItemValueString(ITEM_ML_STATUS).isEmpty()) {
                mlDefinition.setItemValue(ITEM_ML_STATUS, (Object)ML_STATUS_SUGGEST);
                bUpdateDefinitions = true;
                continue;
            }
            if (1 == eventType && mlItems.size() > 0 && ML_STATUS_SUGGEST.equals(mlDefinition.getItemValueString(ITEM_ML_STATUS))) {
                try {
                    Model model = this.modelService.getModelByWorkitem(workitem);
                    ItemCollection event = model.getEvent(workitem.getTaskID(), workitem.getEventID());
                    ItemCollection mlConfig = this.workflowService.evalWorkflowResult(event, "ml-config", workitem, false);
                    if (mlConfig != null && mlConfig.hasItem("status")) {
                        mlDefinition.setItemValue(ITEM_ML_STATUS, (Object)mlConfig.getItemValueString("status"));
                        bUpdateDefinitions = true;
                        continue;
                    }
                    if (!"0".equals(event.getItemValueString("keypublicresult"))) {
                        mlDefinition.setItemValue(ITEM_ML_STATUS, (Object)ML_STATUS_CONFIRMED);
                        bUpdateDefinitions = true;
                        continue;
                    }
                }
                catch (ModelException | PluginException e) {
                    logger.warning("unable to parse current bpmn event: " + e.getMessage());
                }
            }
            if (2 != eventType || !this.trainingSchedulerEnabled || !ML_STATUS_CONFIRMED.equals(mlDefinition.getItemValueString(ITEM_ML_STATUS)) || !"workitemarchive".equals(workitem.getType())) continue;
            mlDefinition.setItemValue(ITEM_ML_STATUS, (Object)ML_STATUS_TRAINING);
            this.eventLogService.createEvent(EVENTLOG_TOPIC_TRAINING, workitem.getUniqueID());
            bUpdateDefinitions = true;
        }
        if (bUpdateDefinitions) {
            this.updateMLDefinitions(processingEvent.getDocument(), mlDefinitionList);
        }
    }

    public String getAllDocumentText(ItemCollection workitem) {
        if (workitem == null) {
            return null;
        }
        String result = "";
        List fileDataList = workitem.getFileData();
        for (FileData fileData : fileDataList) {
            List fileText = (List)fileData.getAttribute("text");
            if (fileText == null || fileText.size() <= 0) continue;
            result = result + fileText.get(0) + " ";
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void trainWorkitem(String uid) {
        ItemCollection workitem = this.workflowService.getWorkItem(uid);
        if (workitem == null) {
            throw new IllegalArgumentException("Invalid workitem uid '" + uid + "!");
        }
        List<ItemCollection> mlDefinitionList = this.getMLDefinitions(workitem);
        Iterator<ItemCollection> iterator = mlDefinitionList.iterator();
        while (iterator.hasNext()) {
            ItemCollection mlDefinition = iterator.next();
            String mlStatus = mlDefinition.getItemValueString(ITEM_ML_STATUS);
            if (!ML_STATUS_TRAINING.equals(mlStatus)) continue;
            String mlEndpoint = mlDefinition.getItemValueString(ITEM_ML_ENDPOINT);
            String mlModel = mlDefinition.getItemValueString(ITEM_ML_MODEL);
            String mlLocals = mlDefinition.getItemValueString(ITEM_ML_LOCALES);
            String mlQuality = mlDefinition.getItemValueString(ITEM_ML_QUALITY);
            logger.info("...train " + mlEndpoint + " model: " + mlModel);
            MLClient mlClient = new MLClient(mlEndpoint);
            String content = this.getAllDocumentText(workitem);
            List itemNames = mlDefinition.getItemValue(ITEM_ML_ITEMS);
            List locales = LocaleHelper.parseLocales((String)mlLocals);
            XMLTrainingData trainingData = new TrainingDataBuilder(content, workitem, itemNames, locales).setAnalyzerEntityEvents(this.entityObjectEvents).build();
            if (0 == trainingData.getQuality()) {
                if (!"REDUCED".equalsIgnoreCase(mlQuality)) {
                    logger.warning("...document '" + workitem.getUniqueID() + "' TRAININGDATA_QUALITY_LEVEL=BAD - document will be ignored!");
                    return;
                }
                logger.info("...document '" + workitem.getUniqueID() + "' TRAININGDATA_QUALITY_LEVEL=BAD but REDUCED is accepted - document will be trained...");
            } else if (trainingData.getQuality() == 2 && "FULL".equalsIgnoreCase(mlQuality)) {
                logger.warning("...document '" + workitem.getUniqueID() + "' TRAININGDATA_QUALITY_LEVEL=PARTIAL but FULL is required - document will be ignored!");
                return;
            }
            if (trainingData.isEmpty()) continue;
            mlClient.postTrainingData(trainingData, mlModel);
        }
        return;
    }

    public void updateMLDefinition(ItemCollection workitem, ItemCollection newMLDefinition) {
        if (!newMLDefinition.hasItem(ITEM_ML_ENDPOINT) || !newMLDefinition.hasItem(ITEM_ML_MODEL)) {
            throw new IllegalArgumentException("A ml definition must contain a least a ml.endpoint and a ml.model!");
        }
        List mlDefinitionList = workitem.getItemValue(ITEM_ML_DEFINITIONS);
        Iterator iter = mlDefinitionList.iterator();
        while (iter.hasNext()) {
            ItemCollection aEndpointDev = new ItemCollection((Map)iter.next());
            if (!newMLDefinition.getItemValueString(ITEM_ML_ENDPOINT).equals(aEndpointDev.getItemValueString(ITEM_ML_ENDPOINT)) || !newMLDefinition.getItemValueString(ITEM_ML_MODEL).equals(aEndpointDev.getItemValueString(ITEM_ML_MODEL))) continue;
            iter.remove();
        }
        mlDefinitionList.add(newMLDefinition.getAllItems());
        workitem.setItemValue(ITEM_ML_DEFINITIONS, (Object)mlDefinitionList);
    }

    public List<ItemCollection> getMLDefinitions(ItemCollection workitem) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        if (!workitem.getItemValueString(ITEM_ML_DEFINITIONS).isEmpty()) {
            List mlDefinitions = workitem.getItemValue(ITEM_ML_DEFINITIONS);
            for (Map aDef : mlDefinitions) {
                result.add(new ItemCollection(aDef));
            }
        }
        return result;
    }

    private void updateMLDefinitions(ItemCollection workitem, List<ItemCollection> mlDefinitionList) {
        ArrayList<Map> newDefinitionList = new ArrayList<Map>();
        for (ItemCollection mlDefinition : mlDefinitionList) {
            newDefinitionList.add(mlDefinition.getAllItems());
        }
        workitem.setItemValue(ITEM_ML_DEFINITIONS, newDefinitionList);
    }
}

