/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.ml.core.MLClient;
import org.imixs.ml.core.MLContentBuilder;
import org.imixs.ml.events.EntityTextEvent;
import org.imixs.ml.workflow.MLService;
import org.imixs.ml.xml.XMLAnalyseEntity;
import org.imixs.ml.xml.XMLAnalyseResult;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;
import util.LocaleHelper;

public class MLAdapter
implements SignalAdapter {
    public static final String ML_ENTITY = "entity";
    public static final String API_ERROR = "API_ERROR";
    public static final int API_EVENT_SUCCESS = 110;
    public static final int API_EVENT_FAILURE = 90;
    private static Logger logger = Logger.getLogger(MLAdapter.class.getName());
    @Inject
    @ConfigProperty(name="ml.service.endpoint")
    Optional<String> mlDefaultAPIEndpoint;
    @Inject
    @ConfigProperty(name="ml.model", defaultValue="imixs-model")
    String mlDefaultModel;
    @Inject
    @ConfigProperty(name="ml.locales", defaultValue="de_DE,en_GB")
    private String mlDefaultLocales;
    @Inject
    @ConfigProperty(name="ml.training.quality", defaultValue="PARTIAL")
    String mlDefaultQualityLevel;
    @Inject
    private WorkflowService workflowService;
    @Inject
    private MLService mlService;
    @Inject
    private Event<EntityTextEvent> entityTextEvents = null;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        String mlAPIEndpoint = null;
        String mlModelName = null;
        String mlLocals = null;
        String mlQuality = null;
        Pattern mlFilenamePattern = null;
        List locals = new ArrayList();
        Map<String, EntityDefinition> entityDefinitions = null;
        boolean debug = logger.isLoggable(Level.FINE);
        debug = true;
        logger.finest("...running api adapter...");
        try {
            ItemCollection mlConfig = this.workflowService.evalWorkflowResult(event, "ml-config", document, false);
            mlAPIEndpoint = this.parseMLEndpointByBPMN(mlConfig);
            mlModelName = this.parseMLModelByBPMN(mlConfig);
            mlLocals = this.parseMLLocalesByBPMN(mlConfig);
            mlQuality = this.parseMLQualityByBPMN(mlConfig);
            String _FilenamePattern = this.parseMLFilePatternByBPMN(mlConfig);
            if (_FilenamePattern != null && !_FilenamePattern.isEmpty()) {
                mlFilenamePattern = Pattern.compile(_FilenamePattern);
            }
            locals = LocaleHelper.parseLocales((String)mlLocals);
            entityDefinitions = this.parseEntityDefinitionsByBPMN(mlConfig);
        }
        catch (PluginException e) {
            logger.warning("Unable to parse item definitions for 'ml-config', verify model - " + e.getMessage());
        }
        if (mlAPIEndpoint == null || mlAPIEndpoint.isEmpty()) {
            throw new ProcessingErrorException(MLAdapter.class.getSimpleName(), API_ERROR, "imixs-ml service endpoint is empty!");
        }
        if (mlAPIEndpoint.indexOf("/analyse") > -1) {
            throw new AdapterException(MLAdapter.class.getSimpleName(), API_ERROR, "imixs-ml wrong service endpoint - should not contain \"/analyzse\" resource!");
        }
        String mlContent = new MLContentBuilder(document, null, false, mlFilenamePattern).build();
        if (!mlContent.isEmpty()) {
            MLClient mlClient = new MLClient(mlAPIEndpoint);
            XMLAnalyseResult result = mlClient.postAnalyseData(mlContent, mlModelName);
            if (result == null) {
                throw new ProcessingErrorException(MLAdapter.class.getSimpleName(), API_ERROR, "imixs-ml api error at endpoint: " + mlAPIEndpoint + "!");
            }
            Map<String, List<String>> groupedEntityList = this.groupTextValues(result);
            for (Map.Entry<String, List<String>> mlEntity : groupedEntityList.entrySet()) {
                EntityDefinition entityDef;
                String mlEntityName = mlEntity.getKey();
                if (!entityDefinitions.containsKey(mlEntityName) || !document.isItemEmpty((entityDef = entityDefinitions.get(mlEntityName)).getItemName())) continue;
                List<String> itemValueList = mlEntity.getValue();
                EntityTextEvent entityTextEvent = new EntityTextEvent(itemValueList, locals, entityDef.getItemType(), entityDef.getLength());
                this.entityTextEvents.fire((Object)entityTextEvent);
                Object _resultValueObject = null;
                if (entityTextEvent.getItemValue() != null) {
                    if (debug) {
                        logger.info("Best match=" + entityTextEvent.getItemValue());
                    }
                    _resultValueObject = entityTextEvent.getItemValue();
                } else if (entityDef.getItemType().isEmpty() || "text".equals(entityDef.getItemType())) {
                    _resultValueObject = mlEntity.getValue().iterator().next();
                }
                if (_resultValueObject instanceof String && _resultValueObject.toString().length() > entityDef.getLength()) {
                    _resultValueObject = _resultValueObject.toString().substring(0, entityDef.getLength()).trim();
                }
                document.setItemValue(entityDef.getItemName(), _resultValueObject);
            }
            ItemCollection mlDefinition = new ItemCollection();
            mlDefinition.setItemValue("ml.endpoint", (Object)mlAPIEndpoint);
            mlDefinition.setItemValue("ml.model", (Object)mlModelName);
            mlDefinition.setItemValue("ml.items", entityDefinitions.keySet());
            mlDefinition.setItemValue("ml.locales", (Object)mlLocals);
            mlDefinition.setItemValue("ml.quality", (Object)mlQuality);
            this.mlService.updateMLDefinition(document, mlDefinition);
        } else {
            logger.finest("......no ml content found to be analysed for " + document.getUniqueID());
        }
        return document;
    }

    private String parseMLEndpointByBPMN(ItemCollection mlConfig) {
        boolean debug = logger.isLoggable(Level.FINE);
        debug = true;
        String mlAPIEndpoint = null;
        mlAPIEndpoint = null;
        if (mlConfig != null) {
            mlAPIEndpoint = mlConfig.getItemValueString("endpoint");
        }
        if ((mlAPIEndpoint == null || mlAPIEndpoint.isEmpty()) && this.mlDefaultAPIEndpoint.isPresent() && !this.mlDefaultAPIEndpoint.get().isEmpty()) {
            mlAPIEndpoint = this.mlDefaultAPIEndpoint.get();
        }
        if (debug) {
            logger.info("......ml api endpoint " + mlAPIEndpoint);
        }
        if (!mlAPIEndpoint.endsWith("/")) {
            mlAPIEndpoint = mlAPIEndpoint + "/";
        }
        return mlAPIEndpoint;
    }

    private String parseMLModelByBPMN(ItemCollection mlConfig) {
        boolean debug = logger.isLoggable(Level.FINE);
        debug = true;
        String mlModel = null;
        if (mlConfig != null) {
            mlModel = mlConfig.getItemValueString("model");
        }
        if (mlModel == null || mlModel.isEmpty()) {
            mlModel = this.mlDefaultModel;
        }
        if (debug) {
            logger.info("......ml model = " + mlModel);
        }
        return mlModel;
    }

    private String parseMLQualityByBPMN(ItemCollection mlConfig) {
        boolean debug = logger.isLoggable(Level.FINE);
        debug = true;
        String mlQuality = null;
        if (mlConfig != null) {
            mlQuality = mlConfig.getItemValueString("quality");
        }
        if (mlQuality == null || mlQuality.isEmpty()) {
            mlQuality = this.mlDefaultQualityLevel;
        }
        if (debug) {
            logger.info("......ml quality = " + mlQuality);
        }
        return mlQuality;
    }

    private String parseMLFilePatternByBPMN(ItemCollection mlConfig) {
        boolean debug = logger.isLoggable(Level.FINE);
        debug = true;
        String filePattern = null;
        if (mlConfig != null) {
            filePattern = mlConfig.getItemValueString("filename.pattern");
        }
        if (debug) {
            logger.info("......ml file.pattern = " + filePattern);
        }
        return filePattern;
    }

    private String parseMLLocalesByBPMN(ItemCollection mlConfig) {
        String mlAPILocales = null;
        if (mlConfig != null) {
            mlAPILocales = mlConfig.getItemValueString("locales");
        }
        if (mlAPILocales == null || mlAPILocales.isEmpty()) {
            mlAPILocales = this.mlDefaultLocales;
        }
        return mlAPILocales;
    }

    private Map<String, EntityDefinition> parseEntityDefinitionsByBPMN(ItemCollection mlConfig) {
        List entityDevList = mlConfig.getItemValue(ML_ENTITY);
        if (entityDevList.size() == 0) {
            throw new ProcessingErrorException(MLAdapter.class.getSimpleName(), API_ERROR, "missing ml-config entity definitions!");
        }
        HashMap<String, EntityDefinition> result = new HashMap<String, EntityDefinition>();
        for (String entityDev : entityDevList) {
            if (entityDev.trim().isEmpty()) continue;
            try {
                ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
                if (entityData == null) continue;
                String name = entityData.getItemValueString("name");
                String type = entityData.getItemValueString("type");
                String mapping = entityData.getItemValueString("mapping");
                int length = entityData.getItemValueInteger("length");
                result.put(name, new EntityDefinition(name, type, mapping, length));
            }
            catch (PluginException e) {
                logger.warning("Invalid ml.config definition with unexpected entity element - verify model!");
            }
        }
        return result;
    }

    private Map<String, List<String>> groupTextValues(XMLAnalyseResult data) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (data != null) {
            for (XMLAnalyseEntity entity : data.getEntities()) {
                String itemName = entity.getLabel();
                String itemValue = entity.getText();
                if (itemName == null || itemName.isEmpty() || itemValue == null || itemValue.isEmpty()) continue;
                List<String> textList = result.get(itemName);
                if (textList == null) {
                    textList = new ArrayList<String>();
                }
                textList.add(itemValue);
                result.put(itemName.trim(), textList);
            }
        }
        return result;
    }

    class EntityDefinition {
        private String name;
        private String itemType;
        private String itemName;
        private int length;

        public EntityDefinition(String name, String itemType, String itemName, int length) {
            if (name == null || name.isEmpty()) {
                logger.warning("Invalid ml.config entity definition - missing name!");
            }
            this.name = name;
            this.itemType = itemType;
            this.itemName = itemName;
            this.length = length;
            if (this.length <= 0) {
                this.length = 128;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getItemType() {
            return this.itemType;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getItemName() {
            if (this.itemName == null || this.itemName.isEmpty()) {
                return this.name;
            }
            return this.itemName;
        }
    }
}

