/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.ConversationScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.ml.workflow.MLService;
import org.imixs.workflow.faces.data.WorkflowController;

@Named(value="mlController")
@ConversationScoped
public class MLController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MLController.class.getName());
    @Inject
    protected WorkflowController workflowController;
    @Inject
    protected MLService mlService;
    private List<String> searchResult = null;

    public boolean isMLItem(String name) {
        if (this.workflowController.getWorkitem() != null) {
            List mlItems = this.workflowController.getWorkitem().getItemValue("ml.items");
            return mlItems.contains(name);
        }
        return false;
    }

    public String getMLResult() {
        String result = "{";
        if (this.workflowController.getWorkitem() != null) {
            List mlItems = this.workflowController.getWorkitem().getItemValue("ml.items");
            result = result + "\"status\":\"" + this.workflowController.getWorkitem().getItemValueString("ml.status") + "\"";
            if (mlItems != null && mlItems.size() > 0) {
                result = result + ",\"items\":";
                result = result + mlItems.stream().map(n -> "\"" + n + "\"").collect(Collectors.joining(",", "[", "]"));
            }
        } else {
            result = result + "\"status\":\"none\"";
        }
        result = result + "}";
        return result;
    }

    public void search() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String phrase = (String)fc.getExternalContext().getRequestParameterMap().get("phrase");
        logger.info("search prase '" + phrase + "'");
        if (phrase == null || phrase.length() < 2) {
            return;
        }
        logger.finest(".......triger search...");
        logger.fine("search for=" + phrase);
        this.searchResult = new ArrayList<String>();
        String text = this.mlService.getAllDocumentText(this.workflowController.getWorkitem());
        if (text != null) {
            this.searchResult = MLController.findMatches(phrase, text);
        }
    }

    public static List<String> findMatches(String phrase, String _text) {
        int found;
        String searchPhrase;
        ArrayList<String> result = new ArrayList<String>();
        String text = _text;
        text = text.replace("\n", " ");
        String searchText = text.toLowerCase();
        String originSearchPhrase = searchPhrase = phrase.toLowerCase();
        int index = 0;
        while ((found = searchText.indexOf(searchPhrase, index)) > -1) {
            String hit = null;
            int endPos = searchText.indexOf(" ", found + searchPhrase.length() + 1);
            if (endPos == -1) {
                endPos = searchText.indexOf(".", found + searchPhrase.length() + 1);
            }
            if ((hit = endPos > -1 ? text.substring(found, endPos).trim() : text.substring(found).trim()).length() > 32) {
                hit = hit.substring(0, 32).trim();
            }
            if (!result.contains(hit)) {
                result.add(hit);
                if (!searchPhrase.endsWith(" ")) {
                    searchPhrase = hit.toLowerCase() + " ";
                } else {
                    searchPhrase = originSearchPhrase;
                    index = found + hit.length();
                }
            } else {
                index = found + hit.length();
            }
            if (result.size() < 7) continue;
            break;
        }
        return result;
    }

    public List<String> getSearchResult() {
        return this.searchResult;
    }

    public void reset() {
        this.searchResult = new ArrayList<String>();
        logger.fine("reset");
    }
}

