/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.core;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.exceptions.AccessDeniedException;

@Stateless
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SnapshotService {
    public static final String REGEX_URL_PATTERN = "^(http|https|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    public static final String SNAPSHOTID = "$snapshotid";
    public static final String TYPE_PRAFIX = "snapshot-";
    public static final String NOSNAPSHOT = "$nosnapshot";
    public static final String SKIPSNAPSHOT = "$skipsnapshot";
    public static final String ITEM_FILEDATA_FILE_NAMES = "$file.names";
    public static final String ITEM_FILEDATA_FILE_COUNT = "$file.count";
    public static final String ITEM_SNAPSHOT_OVERWRITEFILECONTENT = "$snapshot.overwriteFileContent";
    public static final String ITEM_BACKUPRESTORE = "$backuprestore";
    public static final String PROPERTY_SNAPSHOT_WORKITEMLOB_SUPPORT = "snapshot.workitemlob_suport";
    public static final String PROPERTY_SNAPSHOT_HISTORY = "snapshot.history";
    public static final String PROPERTY_SNAPSHOT_OVERWRITEFILECONTENT = "snapshot.overwriteFileContent";
    public static final String ARCHIVE_SERVICE_ENDPOINT = "archive.service.endpoint";
    public static final String ARCHIVE_SERVICE_INTERVAL = "archive.service.interval";
    public static final String ARCHIVE_SERVICE_DEADLOCK = "archive.service.deadlock";
    public static final String ARCHIVE_SERVICE_USER = "archive.service.user";
    public static final String ARCHIVE_SERVICE_PASSWORD = "archive.service.password";
    public static final String ARCHIVE_SERVICE_AUTHMETHOD = "archive.service.authmethod";
    public static final String BACKUP_SERVICE_ENDPOINT = "backup.service.endpoint";
    public static final String EVENTLOG_TOPIC_ADD = "snapshot.add";
    public static final String EVENTLOG_TOPIC_REMOVE = "snapshot.remove";
    public static final String EVENTLOG_TOPIC_BACKUP = "snapshot.backup";
    public static final String ITEM_MD5_CHECKSUM = "md5checksum";
    @Resource
    SessionContext ejbCtx;
    @EJB
    DocumentService documentService;
    @EJB
    EventLogService eventLogService;
    @Inject
    @ConfigProperty(name="snapshot.workitemlob_suport", defaultValue="false")
    boolean allowWorkitemLob;
    @Inject
    @ConfigProperty(name="snapshot.overwriteFileContent", defaultValue="false")
    boolean overwriteFileContent;
    @Inject
    @ConfigProperty(name="snapshot.history", defaultValue="1")
    int iSnapshotHistory;
    @Inject
    @ConfigProperty(name="archive.service.endpoint")
    Optional<String> archiveServiceEndpoint;
    @Inject
    @ConfigProperty(name="backup.service.endpoint")
    Optional<String> backupServiceEndpoint;
    private static Logger logger = Logger.getLogger(SnapshotService.class.getName());

    public void onSave(@Observes DocumentEvent documentEvent) {
        boolean debug = logger.isLoggable(Level.FINE);
        Object type = documentEvent.getDocument().getType();
        if (documentEvent.getEventType() != 1) {
            return;
        }
        if (((String)type).startsWith(TYPE_PRAFIX)) {
            return;
        }
        if ("model".equals(type)) {
            return;
        }
        if (documentEvent.getDocument().getItemValueBoolean(NOSNAPSHOT)) {
            return;
        }
        if (documentEvent.getDocument().getItemValueBoolean(SKIPSNAPSHOT)) {
            documentEvent.getDocument().removeItem(SKIPSNAPSHOT);
            return;
        }
        if ("workitemlob".equals(type)) {
            if (this.allowWorkitemLob) {
                return;
            }
            throw new SnapshotException("INVALID_DATA", "deprecated workitemlob - SnapshotService can not be combined with deprecated version of marty (3.1).");
        }
        try {
            this.updateCustomAttributes(documentEvent.getDocument(), this.ejbCtx.getCallerPrincipal().getName());
        }
        catch (IllegalStateException | NoSuchAlgorithmException e) {
            throw new SnapshotException("INVALID_DATA", "Update DMS Meta Data failed: " + e.getMessage(), e);
        }
        if (debug) {
            logger.fine("creating new snapshot-workitem.... ");
        }
        ItemCollection snapshot = (ItemCollection)documentEvent.getDocument().clone();
        String snapshotUniqueID = documentEvent.getDocument().getUniqueID() + "-" + System.currentTimeMillis();
        if (debug) {
            logger.fine("snapshot-uniqueid=" + snapshotUniqueID);
        }
        snapshot.replaceItemValue("$uniqueid", (Object)snapshotUniqueID);
        type = TYPE_PRAFIX + documentEvent.getDocument().getType();
        if (debug) {
            logger.fine("new document type = " + (String)type);
        }
        snapshot.replaceItemValue("type", type);
        ItemCollection lastSnapshot = this.documentService.load(documentEvent.getDocument().getItemValueString(SNAPSHOTID));
        boolean isBlobWorkitem = false;
        if (lastSnapshot == null && !documentEvent.getDocument().getItemValueString("$uniqueidsource").isEmpty()) {
            if (debug) {
                logger.fine("lookup last snapshot from origin version: '" + documentEvent.getDocument().getItemValueString("$uniqueidsource") + "'");
            }
            lastSnapshot = this.documentService.load(documentEvent.getDocument().getItemValueString(SNAPSHOTID));
        }
        if (lastSnapshot == null && !documentEvent.getDocument().getItemValueString("$blobworkitem").isEmpty()) {
            if (debug) {
                logger.fine("lookup last blobworkitem: '" + documentEvent.getDocument().getItemValueString("$blobworkitem") + "'");
            }
            if ((lastSnapshot = this.documentService.load(documentEvent.getDocument().getItemValueString("$blobworkitem"))) != null) {
                logger.info("migrating file content from deprecated blobWorkitem '" + documentEvent.getDocument().getUniqueID() + "' ....");
                isBlobWorkitem = true;
            }
        }
        if (lastSnapshot != null) {
            this.copyFilesFromItemCollection(lastSnapshot, snapshot, documentEvent.getDocument(), this.overwriteFileContent, isBlobWorkitem);
        }
        List files = documentEvent.getDocument().getFileData();
        byte[] empty = new byte[]{};
        for (FileData fileData : files) {
            if (fileData.getContent() == null || fileData.getContent().length <= 0) continue;
            if (debug) {
                logger.fine("drop content for file '" + fileData.getName() + "'");
            }
            FileData _fileData = new FileData(fileData.getName(), empty, fileData.getContentType(), fileData.getAttributes());
            documentEvent.getDocument().addFileData(_fileData);
        }
        documentEvent.getDocument().replaceItemValue(SNAPSHOTID, (Object)snapshot.getUniqueID());
        snapshot.replaceItemValue("$noindex", (Object)true);
        snapshot.replaceItemValue("$immutable", (Object)true);
        this.documentService.save(snapshot);
        this.cleanSnaphostHistory(snapshot.getUniqueID());
        if (this.archiveServiceEndpoint.isPresent() && !this.archiveServiceEndpoint.get().isEmpty()) {
            if (debug) {
                logger.finest("......create event log entry snapshot.add");
            }
            this.eventLogService.createEvent(EVENTLOG_TOPIC_ADD, snapshot.getUniqueID());
        } else if (this.backupServiceEndpoint.isPresent() && !this.backupServiceEndpoint.get().isEmpty()) {
            if (debug) {
                logger.finest("......create event log entry snapshot.backup");
            }
            this.eventLogService.createEvent(EVENTLOG_TOPIC_BACKUP, snapshot.getUniqueID());
        }
    }

    public void onDelete(@Observes DocumentEvent documentEvent) {
        ItemCollection lobWorkitem;
        String type = documentEvent.getDocument().getType();
        if (documentEvent.getEventType() != 3) {
            return;
        }
        if (type.startsWith(TYPE_PRAFIX)) {
            return;
        }
        if (!documentEvent.getDocument().getItemValueString("$blobworkitem").isEmpty() && (lobWorkitem = this.documentService.load(documentEvent.getDocument().getItemValueString("$blobworkitem"))) != null) {
            logger.info("delete deprecated blobworkitem: '" + documentEvent.getDocument().getItemValueString("$blobworkitem") + "'");
            this.documentService.remove(lobWorkitem);
        }
        List<ItemCollection> snappshotList = this.findAllSnapshots(documentEvent.getDocument().getUniqueID());
        for (ItemCollection snapshot : snappshotList) {
            this.documentService.remove(snapshot);
        }
    }

    public List<ItemCollection> findAllSnapshots(String uniqueid) {
        if (uniqueid == null || uniqueid.isEmpty()) {
            throw new SnapshotException("INVALID_UNIQUEID", "undefined $uniqueid");
        }
        String query = "SELECT document FROM Document AS document WHERE document.id > '" + uniqueid + "-' AND document.id < '" + uniqueid + "-9999999999999' ORDER BY document.id DESC";
        return this.documentService.getDocumentsByQuery(query, 999);
    }

    public ItemCollection findSnapshot(ItemCollection workitem) {
        String snapshotID = workitem.getItemValueString(SNAPSHOTID);
        if (!snapshotID.isEmpty()) {
            return this.documentService.load(snapshotID);
        }
        return null;
    }

    public FileData getWorkItemFile(String uniqueid, String file) {
        ItemCollection workItem = this.documentService.load(uniqueid);
        String snapshotID = workItem.getItemValueString(SNAPSHOTID);
        ItemCollection snapshot = this.documentService.load(snapshotID);
        if (snapshot != null) {
            return snapshot.getFileData(file);
        }
        return null;
    }

    void cleanSnaphostHistory(String snapshotID) {
        if (snapshotID == null || snapshotID.isEmpty()) {
            throw new SnapshotException("INVALID_UNIQUEID", "invalid $snapshotid");
        }
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.fine("snapshot.history = " + this.iSnapshotHistory);
        }
        if (this.iSnapshotHistory == 0) {
            return;
        }
        if (debug) {
            logger.fine("cleanSnaphostHistory for $snapshotid: " + snapshotID);
        }
        String snapshtIDPfafix = snapshotID.substring(0, snapshotID.lastIndexOf(45));
        String query = "SELECT document FROM Document AS document WHERE document.id > '" + snapshtIDPfafix + "-' AND document.id < '" + snapshotID + "' ORDER BY document.id ASC";
        List result = this.documentService.getDocumentsByQuery(query);
        while (result.size() >= this.iSnapshotHistory) {
            ItemCollection oldSnapshot = (ItemCollection)result.get(0);
            if (debug) {
                logger.fine("remove deprecated snapshot: " + oldSnapshot.getUniqueID());
            }
            try {
                if (this.documentService.load(oldSnapshot.getUniqueID()) != null) {
                    this.documentService.remove(oldSnapshot);
                } else if (debug) {
                    logger.fine("......snapshot '" + oldSnapshot.getUniqueID() + "' can't be deleted in this transaction context.");
                }
            }
            catch (AccessDeniedException e) {
                logger.warning("remove deprecated snapshot '" + oldSnapshot.getUniqueID() + "' failed, snapshot context='" + snapshotID + "' - failure: " + e.getMessage());
            }
            result.remove(0);
        }
    }

    private void copyFilesFromItemCollection(ItemCollection source, ItemCollection target, ItemCollection origin, boolean overwriteFileContent, boolean blobWorkitem) {
        boolean debug = logger.isLoggable(Level.FINE);
        List files = target.getFileData();
        List overwriteFileList = origin.getItemValueList(ITEM_SNAPSHOT_OVERWRITEFILECONTENT, String.class);
        for (FileData fileData : files) {
            FileData oldFileData;
            String fileName = fileData.getName();
            byte[] content = fileData.getContent();
            if (content.length == 0 || blobWorkitem && content.length <= 2) {
                if (source != null) {
                    oldFileData = source.getFileData(fileName);
                    if (oldFileData != null) {
                        if (debug) {
                            logger.fine("copy file content '" + fileName + "' from: " + source.getUniqueID());
                        }
                        target.addFileData(new FileData(fileName, oldFileData.getContent(), oldFileData.getContentType(), oldFileData.getAttributes()));
                        continue;
                    }
                    if (fileName.matches(REGEX_URL_PATTERN)) {
                        if (!debug) continue;
                        logger.fine("URL - no file content for " + fileName);
                        continue;
                    }
                    logger.warning("Missing file content!");
                    continue;
                }
                logger.warning("Missing file content!");
                continue;
            }
            if (overwriteFileContent || overwriteFileList.contains(fileName) || (oldFileData = source.getFileData(fileName)) == null) continue;
            ItemCollection dmsColOrigin = new ItemCollection(fileData.getAttributes());
            ItemCollection dmsColOld = new ItemCollection(oldFileData.getAttributes());
            if (dmsColOrigin == null || dmsColOld == null || dmsColOrigin.getItemValueString(ITEM_MD5_CHECKSUM).equals(dmsColOld.getItemValueString(ITEM_MD5_CHECKSUM))) continue;
            Date fileDate = dmsColOld.getItemValueDate("$modified");
            if (fileDate == null) {
                fileDate = dmsColOld.getItemValueDate("$created");
            }
            if (fileDate == null) {
                fileDate = new Date();
            }
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("[yyyy-MM-dd'T'HH:mm:ss.SSS'Z']");
            df.setTimeZone(tz);
            String sTimeStamp = df.format(fileDate);
            String protectedFileName = null;
            int iFileDot = fileName.lastIndexOf(46);
            protectedFileName = iFileDot > 0 ? fileName.substring(0, iFileDot) + "-" + sTimeStamp + fileName.substring(iFileDot) : fileName + "-" + sTimeStamp;
            byte[] empty = new byte[]{};
            dmsColOld.replaceItemValue("txtname", (Object)protectedFileName);
            target.addFileData(new FileData(protectedFileName, oldFileData.getContent(), oldFileData.getContentType(), dmsColOld.getAllItems()));
            origin.addFileData(new FileData(protectedFileName, empty, oldFileData.getContentType(), dmsColOld.getAllItems()));
        }
        origin.replaceItemValue(ITEM_SNAPSHOT_OVERWRITEFILECONTENT, (Object)"");
    }

    private void updateCustomAttributes(ItemCollection workitem, String username) throws NoSuchAlgorithmException {
        List currentFileData = workitem.getFileData();
        for (FileData fileData : currentFileData) {
            ItemCollection customAtributes = new ItemCollection(fileData.getAttributes());
            if (fileData.getContent() == null || fileData.getContent().length <= 1) continue;
            String oldChecksum = customAtributes.getItemValueString(ITEM_MD5_CHECKSUM);
            String newChecksum = fileData.generateMD5();
            customAtributes.replaceItemValue(ITEM_MD5_CHECKSUM, (Object)newChecksum);
            customAtributes.replaceItemValue("size", (Object)fileData.getContent().length);
            customAtributes.replaceItemValue("txtname", (Object)fileData.getName());
            Date eventDate = workitem.getItemValueDate("$lasteventdate");
            if (eventDate == null) {
                eventDate = new Date();
            }
            if (!oldChecksum.isEmpty() && !oldChecksum.equals(newChecksum)) {
                customAtributes.replaceItemValue("$modified", (Object)eventDate);
                customAtributes.replaceItemValue("$editor", (Object)username);
            } else {
                customAtributes.replaceItemValue("$created", (Object)eventDate);
                customAtributes.replaceItemValue("$creator", (Object)username);
                customAtributes.replaceItemValue("namcreator", (Object)username);
            }
            fileData.setAttributes(customAtributes.getAllItems());
            workitem.addFileData(fileData);
        }
    }
}

