/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.core.cassandra;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;

@Stateless
@LocalBean
public class ArchiveRemoteService {
    @Inject
    @ConfigProperty(name="archive.service.endpoint")
    Optional<String> archiveServiceEndpoint;
    @Inject
    @ConfigProperty(name="archive.service.user")
    Optional<String> archiveServiceUser;
    @Inject
    @ConfigProperty(name="archive.service.password")
    Optional<String> archiveServicePassword;
    @Inject
    @ConfigProperty(name="archive.service.authmethod")
    Optional<String> archiveServiceAuthMethod;
    private static Logger logger = Logger.getLogger(ArchiveRemoteService.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadFileFromArchive(FileData fileData) throws RestAPIException {
        if (fileData == null) {
            return null;
        }
        if (!this.archiveServiceEndpoint.isPresent() || this.archiveServiceEndpoint.get().isEmpty()) {
            logger.warning("missing archive service endpoint - verify configuration!");
            return null;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        if (fileData != null) {
            ItemCollection dmsData = new ItemCollection(fileData.getAttributes());
            String md5 = dmsData.getItemValueString("md5checksum");
            if (!md5.isEmpty()) {
                try {
                    DocumentClient documentClient = this.initDocumentClient();
                    if (documentClient != null) {
                        Client rsClient = documentClient.newClient();
                        String url = this.archiveServiceEndpoint.get() + "/archive/md5/" + md5;
                        Response response = rsClient.target(url).request(new String[]{"application/octet-stream"}).get();
                        byte[] fileContent = null;
                        try {
                            fileContent = (byte[])response.readEntity(byte[].class);
                            if (fileContent != null && fileContent.length > 0 && debug) {
                                logger.finest("......md5 data object found");
                            }
                        }
                        finally {
                            response.close();
                            rsClient.close();
                        }
                        return fileContent;
                    }
                    logger.warning("Unable to initalize document client!");
                }
                catch (ProcessingException e) {
                    String message = null;
                    message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                    throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error load file by MD5 checksum -> " + message, (Exception)((Object)e));
                }
            }
            return null;
        }
        return null;
    }

    private DocumentClient initDocumentClient() {
        boolean debug = logger.isLoggable(Level.FINE);
        DocumentClient documentClient = new DocumentClient(this.archiveServiceEndpoint.get());
        if (this.archiveServiceAuthMethod.isPresent()) {
            if ("form".equalsIgnoreCase(this.archiveServiceAuthMethod.get())) {
                if (debug) {
                    logger.finest("......Form Based authentication");
                }
                FormAuthenticator formAuth = new FormAuthenticator(this.archiveServiceEndpoint.get(), this.archiveServiceUser.get(), this.archiveServicePassword.get());
                documentClient.registerClientRequestFilter((ClientRequestFilter)formAuth);
            }
            if ("basic".equalsIgnoreCase(this.archiveServiceAuthMethod.get())) {
                if (debug) {
                    logger.finest("......Basic authentication");
                }
                BasicAuthenticator basicAuth = new BasicAuthenticator(this.archiveServiceUser.get(), this.archiveServicePassword.get());
                documentClient.registerClientRequestFilter((ClientRequestFilter)basicAuth);
            }
        }
        return documentClient;
    }
}

