/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.core.cassandra;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;

@Stateless
@LocalBean
public class ArchiveRemoteService {
    @Inject
    @ConfigProperty(name="archive.service.endpoint", defaultValue="")
    String archiveServiceEndpoint;
    @Inject
    @ConfigProperty(name="archive.service.user", defaultValue="")
    String archiveServiceUser;
    @Inject
    @ConfigProperty(name="archive.service.password", defaultValue="")
    String archiveServicePassword;
    @Inject
    @ConfigProperty(name="archive.service.authmethod", defaultValue="")
    String archiveServiceAuthMethod;
    private static Logger logger = Logger.getLogger(ArchiveRemoteService.class.getName());

    public byte[] loadFileFromArchive(FileData fileData) throws RestAPIException {
        block7: {
            if (fileData == null) {
                return null;
            }
            boolean debug = logger.isLoggable(Level.FINE);
            if (fileData != null) {
                ItemCollection dmsData = new ItemCollection(fileData.getAttributes());
                String md5 = dmsData.getItemValueString("md5checksum");
                if (!md5.isEmpty()) {
                    try {
                        DocumentClient documentClient = this.initDocumentClient();
                        Client rsClient = documentClient.newClient();
                        String url = this.archiveServiceEndpoint + "/archive/md5/" + md5;
                        Response reponse = rsClient.target(url).request(new String[]{"application/octet-stream"}).get();
                        byte[] fileContent = (byte[])reponse.readEntity(byte[].class);
                        if (fileContent != null && fileContent.length > 0) {
                            if (debug) {
                                logger.finest("......md5 data object found");
                            }
                            return fileContent;
                        }
                        break block7;
                    }
                    catch (ProcessingException e) {
                        String message = null;
                        message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                        throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error load file by MD5 checksum -> " + message, (Exception)((Object)e));
                    }
                }
                return null;
            }
        }
        return null;
    }

    public DocumentClient initDocumentClient() {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest("...... ARCHIVE_SERVICE_ENDPOINT = " + this.archiveServiceEndpoint);
        }
        DocumentClient documentClient = new DocumentClient(this.archiveServiceEndpoint);
        if ("Form".equalsIgnoreCase(this.archiveServiceAuthMethod)) {
            FormAuthenticator formAuth = new FormAuthenticator(this.archiveServiceEndpoint, this.archiveServiceUser, this.archiveServicePassword);
            documentClient.registerClientRequestFilter((ClientRequestFilter)formAuth);
        } else {
            BasicAuthenticator basicAuth = new BasicAuthenticator(this.archiveServiceUser, this.archiveServicePassword);
            documentClient.registerClientRequestFilter((ClientRequestFilter)basicAuth);
        }
        return documentClient;
    }
}

