/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.core.cassandra;

import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.cassandra.ArchiveRemoteService;
import org.imixs.workflow.engine.EventLogService;

@Startup
@Singleton
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class ArchiveScheduler {
    @Inject
    @ConfigProperty(name="archive.service.interval", defaultValue="1000")
    long interval;
    @Inject
    @ConfigProperty(name="archive.service.deadlock", defaultValue="60000")
    long deadLockInterval;
    @Inject
    @ConfigProperty(name="archive.service.endpoint", defaultValue="")
    String archiveServiceEndpoint;
    @Inject
    EventLogService eventLogService;
    @Inject
    ArchiveRemoteService archiveClientService;
    @Resource
    ManagedScheduledExecutorService scheduler;
    private static Logger logger = Logger.getLogger(ArchiveScheduler.class.getName());

    @PostConstruct
    public void init() {
        if (this.archiveServiceEndpoint != null && !this.archiveServiceEndpoint.isEmpty()) {
            logger.info("Starting ArchivePushService - inverval=" + this.interval + " ....");
            this.scheduler.scheduleAtFixedRate(this::run, this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    public void run() {
        this.eventLogService.releaseDeadLocks(this.deadLockInterval, new String[]{"snapshot.add", "snapshot.remove"});
        this.archiveClientService.processEventLog();
    }
}

