/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.core.cassandra;

import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.jpa.EventLog;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
@LocalBean
public class ArchiveClientService {
    @Inject
    @ConfigProperty(name="archive.service.endpoint", defaultValue="")
    String archiveServiceEndpoint;
    @Inject
    @ConfigProperty(name="archive.service.user", defaultValue="")
    String archiveServiceUser;
    @Inject
    @ConfigProperty(name="archive.service.password", defaultValue="")
    String archiveServicePassword;
    @Inject
    @ConfigProperty(name="archive.service.authmethod", defaultValue="")
    String archiveServiceAuthMethod;
    @EJB
    EventLogService eventLogService;
    @EJB
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(ArchiveClientService.class.getName());

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void pushSnapshot(EventLog eventLogEntry) {
        if (eventLogEntry == null) {
            return;
        }
        logger.finest("...push " + eventLogEntry.getRef() + "...");
        long l = System.currentTimeMillis();
        ItemCollection snapshot = this.documentService.load(eventLogEntry.getRef());
        if (snapshot != null) {
            DocumentClient documentClient = this.initWorkflowClient();
            String url = this.archiveServiceEndpoint + "/archive";
            try {
                documentClient.postXMLDocument(url, XMLDocumentAdapter.getDocument((ItemCollection)snapshot));
                this.eventLogService.removeEvent(eventLogEntry);
                logger.info("...pushed " + eventLogEntry.getRef() + " in " + (System.currentTimeMillis() - l) + "ms");
            }
            catch (RestAPIException e) {
                logger.severe("...failed to push snapshot: " + snapshot.getUniqueID() + " : " + e.getMessage());
            }
        } else {
            this.eventLogService.removeEvent(eventLogEntry);
        }
    }

    public byte[] loadFileFromArchive(FileData fileData) throws RestAPIException {
        block6: {
            if (fileData == null) {
                return null;
            }
            if (fileData != null) {
                ItemCollection dmsData = new ItemCollection(fileData.getAttributes());
                String md5 = dmsData.getItemValueString("md5checksum");
                if (!md5.isEmpty()) {
                    try {
                        DocumentClient documentClient = this.initWorkflowClient();
                        Client rsClient = documentClient.newClient();
                        String url = this.archiveServiceEndpoint + "/archive/md5/" + md5;
                        Response reponse = rsClient.target(url).request(new String[]{"application/octet-stream"}).get();
                        byte[] fileContent = (byte[])reponse.readEntity(byte[].class);
                        if (fileContent != null && fileContent.length > 0) {
                            logger.info("md5 daten gefunden");
                            return fileContent;
                        }
                        break block6;
                    }
                    catch (ProcessingException e) {
                        String message = null;
                        message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                        throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error load file by MD5 checksum -> " + message, (Exception)((Object)e));
                    }
                }
                return null;
            }
        }
        return null;
    }

    public DocumentClient initWorkflowClient() {
        logger.finest("...... WORKFLOW_SERVICE_ENDPOINT = " + this.archiveServiceEndpoint);
        DocumentClient documentClient = new DocumentClient(this.archiveServiceEndpoint);
        if ("Form".equalsIgnoreCase(this.archiveServiceAuthMethod)) {
            FormAuthenticator formAuth = new FormAuthenticator(this.archiveServiceEndpoint, this.archiveServiceUser, this.archiveServicePassword);
            documentClient.registerClientRequestFilter((ClientRequestFilter)formAuth);
        } else {
            BasicAuthenticator basicAuth = new BasicAuthenticator(this.archiveServiceUser, this.archiveServicePassword);
            documentClient.registerClientRequestFilter((ClientRequestFilter)basicAuth);
        }
        return documentClient;
    }
}

