/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.core.api;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotException;
import org.imixs.archive.core.cassandra.ArchiveClientService;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.jaxrs.WorkflowRestService;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Named(value="snapshotService")
@RequestScoped
@Path(value="/snapshot")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
public class SnapshotRestService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    @ConfigProperty(name="archive.service.endpoint", defaultValue="")
    String archiveServiceEndpoint;
    @Context
    private HttpServletRequest servletRequest;
    @EJB
    DocumentService documentService;
    @EJB
    WorkflowRestService workflowRestService;
    @EJB
    ArchiveClientService archiveClientService;
    private static Logger logger = Logger.getLogger(SnapshotRestService.class.getName());

    @GET
    @Path(value="/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}/file/{file}")
    public Response getWorkItemFile(@PathParam(value="uniqueid") String uniqueid, @PathParam(value="file") @Encoded String file, @Context UriInfo uriInfo) {
        FileData fileData = null;
        String sTargetID = uniqueid;
        ItemCollection workItem = this.documentService.load(uniqueid);
        try {
            String fileNameUTF8 = URLDecoder.decode(file, "UTF-8");
            String fileNameISO = URLDecoder.decode(file, "ISO-8859-1");
            fileData = workItem.getFileData(fileNameUTF8);
            if (fileData == null) {
                fileData = workItem.getFileData(fileNameISO);
            }
            if (fileData == null) {
                fileData = workItem.getFileData(file);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (!this.archiveServiceEndpoint.isEmpty()) {
            try {
                long l = System.currentTimeMillis();
                byte[] fileContent = this.archiveClientService.loadFileFromArchive(fileData);
                if (fileContent != null) {
                    Response.ResponseBuilder builder = Response.ok((Object)fileContent, (String)fileData.getContentType());
                    logger.info("......loaded filecontent form archive by MD5 checksum in " + (System.currentTimeMillis() - l) + "ms");
                    return builder.build();
                }
            }
            catch (RestAPIException e) {
                logger.severe("failed to load file from archive: " + e.getMessage());
            }
        }
        if (workItem != null && workItem.hasItem("$snapshotid")) {
            sTargetID = workItem.getItemValueString("$snapshotid");
        } else if (workItem != null && workItem.hasItem("$blobworkitem")) {
            sTargetID = workItem.getItemValueString("$blobworkitem");
        }
        return this.workflowRestService.getWorkItemFile(sTargetID, file, uriInfo);
    }

    @GET
    @Path(value="/syncpoint/{syncpoint}")
    public XMLDataCollection getDocumentsBySyncPoint(@PathParam(value="syncpoint") long lSyncpoint) {
        List result = null;
        Date syncpoint = new Date(lSyncpoint);
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String query = "SELECT document FROM Document AS document ";
        query = query + " WHERE document.modified > '" + isoFormat.format(syncpoint) + "'";
        query = query + " AND document.type LIKE 'snapshot-%' ";
        query = query + " ORDER BY document.modified ASC";
        logger.finest("......QUERY=" + query);
        result = this.documentService.getDocumentsByQuery(query, 1);
        if (result == null || result.size() == 0) {
            return null;
        }
        ItemCollection document = (ItemCollection)result.get(0);
        syncpoint = document.getItemValueDate("$modified");
        query = "SELECT document FROM Document AS document ";
        query = query + " WHERE document.modified = '" + isoFormat.format(syncpoint) + "'";
        query = query + " AND document.type LIKE 'snapshot-%' ";
        logger.finest("......QUERY=" + query);
        result = this.documentService.getDocumentsByQuery(query, 17);
        if (result.size() > 16) {
            throw new SnapshotException("INVALID_DATA", "more than 16 document entites are found with the same modified timestamp. We assumed that this case is impossible. Sync is not possible.");
        }
        if (result.size() == 0) {
            throw new SnapshotException("INVALID_DATA", "failed to load snapshot by modified timestamp. We assumed that this case is impossible. Sync is not possible.");
        }
        return XMLDataCollectionAdapter.getDataCollection((Collection)result);
    }

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml"})
    public Response postSnapshot(XMLDocument xmlworkitem) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection snapshot = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem);
        if (snapshot == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        try {
            if (this.documentService.load(snapshot.getUniqueID()) == null) {
                snapshot = this.documentService.save(snapshot);
                logger.info("......snapshot '" + snapshot.getUniqueID() + "' restored.");
            }
            ItemCollection document = new ItemCollection(snapshot);
            String snapshotID = snapshot.getUniqueID();
            String originUnqiueID = snapshotID.substring(0, snapshotID.lastIndexOf("-"));
            document.setItemValue("$uniqueid", (Object)originUnqiueID);
            document.removeItem("$noindex");
            document.removeItem("$immutable");
            document.removeItem("$version");
            List files = document.getFileData();
            byte[] empty = new byte[]{};
            for (FileData fileData : files) {
                if (fileData.getContent() == null || fileData.getContent().length <= 0) continue;
                logger.fine("drop content for file '" + fileData.getName() + "'");
                document.addFileData(new FileData(fileData.getName(), empty, fileData.getContentType(), fileData.getAttributes()));
            }
            String type = document.getType();
            if (type.startsWith("snapshot-")) {
                type = type.substring("snapshot-".length());
                document.setItemValue("type", (Object)type);
            }
            document.setItemValue("$skipsnapshot", (Object)true);
            document.setItemValue("$snapshotid", (Object)snapshotID);
            document = this.documentService.save(document);
            logger.info("......document '" + originUnqiueID + "' restored.");
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)document), (String)"application/xml").build();
        }
        catch (AccessDeniedException e) {
            logger.severe(e.getMessage());
            snapshot = this.addErrorMessage((Exception)((Object)e), snapshot);
        }
        catch (RuntimeException e) {
            logger.severe(e.getMessage());
            snapshot = this.addErrorMessage(e, snapshot);
        }
        try {
            if (snapshot.hasItem("$error_code")) {
                return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)snapshot), (String)"application/xml").status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)snapshot), (String)"application/xml").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @GET
    @Path(value="/ping")
    public String ping() {
        return "ping = " + System.currentTimeMillis();
    }

    private ItemCollection addErrorMessage(Exception pe, ItemCollection aworkitem) {
        if (pe instanceof RuntimeException && pe.getCause() != null) {
            pe = (RuntimeException)pe.getCause();
        }
        if (pe instanceof InvalidAccessException) {
            aworkitem.replaceItemValue("$error_code", (Object)((InvalidAccessException)pe).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        } else {
            aworkitem.replaceItemValue("$error_code", (Object)"INTERNAL ERROR");
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        }
        return aworkitem;
    }
}

