/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.core;

import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import org.imixs.archive.core.SnapshotException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.PropertyService;
import org.imixs.workflow.exceptions.AccessDeniedException;

@Stateless
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SnapshotService {
    public static final String ITEM_MD5_CHECKSUM = "md5checksum";
    @Resource
    SessionContext ejbCtx;
    @EJB
    DocumentService documentService;
    @EJB
    PropertyService propertyService;
    private static Logger logger = Logger.getLogger(SnapshotService.class.getName());
    public static final String SNAPSHOTID = "$snapshotid";
    public static final String TYPE_PRAFIX = "snapshot-";
    public static final String NOSNAPSHOT = "$nosnapshot";
    public static final String SKIPSNAPSHOT = "$skipsnapshot";
    public static final String ITEM_DMS_FILE_NAMES = "dms_names";
    public static final String ITEM_DMS_FILE_COUNT = "dms_count";
    public static final String ITEM_DMS = "dms";
    public static final String PROPERTY_SNAPSHOT_WORKITEMLOB_SUPPORT = "snapshot.workitemlob_suport";
    public static final String PROPERTY_SNAPSHOT_HISTORY = "snapshot.history";
    public static final String PROPERTY_SNAPSHOT_OVERWRITEFILECONTENT = "snapshot.overwriteFileContent";

    public void onSave(@Observes DocumentEvent documentEvent) {
        String type = documentEvent.getDocument().getType();
        if (documentEvent.getEventType() != 1) {
            return;
        }
        if (type.startsWith(TYPE_PRAFIX)) {
            return;
        }
        if ("model".equals(type)) {
            return;
        }
        if (documentEvent.getDocument().getItemValueBoolean(NOSNAPSHOT)) {
            return;
        }
        if (documentEvent.getDocument().getItemValueBoolean(SKIPSNAPSHOT)) {
            documentEvent.getDocument().removeItem(SKIPSNAPSHOT);
            return;
        }
        if ("workitemlob".equals(type)) {
            Boolean allowWorkitemLob = Boolean.parseBoolean(this.propertyService.getProperties().getProperty(PROPERTY_SNAPSHOT_WORKITEMLOB_SUPPORT, "false"));
            if (allowWorkitemLob.booleanValue()) {
                return;
            }
            throw new SnapshotException("INVALID_DATA", "deprecated workitemlob - SnapshotService can not be combined with deprecated version of marty (3.1).");
        }
        try {
            this.updateCustomAttributes(documentEvent.getDocument(), this.ejbCtx.getCallerPrincipal().getName());
        }
        catch (IllegalStateException | NoSuchAlgorithmException e) {
            throw new SnapshotException("INVALID_DATA", "Update DMS Meta Data failed: " + e.getMessage(), e);
        }
        logger.fine("creating new snapshot-workitem.... ");
        ItemCollection snapshot = (ItemCollection)documentEvent.getDocument().clone();
        String snapshotUniqueID = documentEvent.getDocument().getUniqueID() + "-" + System.currentTimeMillis();
        logger.fine("snapshot-uniqueid=" + snapshotUniqueID);
        snapshot.replaceItemValue("$uniqueid", (Object)snapshotUniqueID);
        type = TYPE_PRAFIX + documentEvent.getDocument().getType();
        logger.fine("new document type = " + type);
        snapshot.replaceItemValue("type", (Object)type);
        boolean overwriteFileContent = Boolean.parseBoolean(this.propertyService.getProperties().getProperty(PROPERTY_SNAPSHOT_OVERWRITEFILECONTENT, "false"));
        ItemCollection lastSnapshot = this.documentService.load(documentEvent.getDocument().getItemValueString(SNAPSHOTID));
        boolean isBlobWorkitem = false;
        if (lastSnapshot == null && !documentEvent.getDocument().getItemValueString("$uniqueidsource").isEmpty()) {
            logger.fine("lookup last snapshot from origin version: '" + documentEvent.getDocument().getItemValueString("$uniqueidsource") + "'");
            lastSnapshot = this.documentService.load(documentEvent.getDocument().getItemValueString(SNAPSHOTID));
        }
        if (lastSnapshot == null && !documentEvent.getDocument().getItemValueString("$blobworkitem").isEmpty()) {
            logger.fine("lookup last blobworkitem: '" + documentEvent.getDocument().getItemValueString("$blobworkitem") + "'");
            lastSnapshot = this.documentService.load(documentEvent.getDocument().getItemValueString("$blobworkitem"));
            if (lastSnapshot != null) {
                logger.info("migrating file content from deprecated blobWorkitem '" + documentEvent.getDocument().getUniqueID() + "' ....");
                isBlobWorkitem = true;
            }
        }
        if (lastSnapshot != null) {
            this.copyFilesFromItemCollection(lastSnapshot, snapshot, documentEvent.getDocument(), overwriteFileContent, isBlobWorkitem);
        }
        List files = documentEvent.getDocument().getFileData();
        byte[] empty = new byte[]{};
        for (FileData fileData : files) {
            if (fileData.getContent() == null || fileData.getContent().length <= 0) continue;
            logger.fine("drop content for file '" + fileData.getName() + "'");
            documentEvent.getDocument().addFileData(new FileData(fileData.getName(), empty, fileData.getContentType(), fileData.getAttributes()));
        }
        documentEvent.getDocument().replaceItemValue(SNAPSHOTID, (Object)snapshot.getUniqueID());
        snapshot.replaceItemValue("$noindex", (Object)true);
        snapshot.replaceItemValue("$immutable", (Object)true);
        this.documentService.save(snapshot);
        this.cleanSnaphostHistory(snapshot.getUniqueID());
    }

    public void onDelete(@Observes DocumentEvent documentEvent) {
        ItemCollection lobWorkitem;
        String type = documentEvent.getDocument().getType();
        if (documentEvent.getEventType() != 3) {
            return;
        }
        if (type.startsWith(TYPE_PRAFIX)) {
            return;
        }
        if (!documentEvent.getDocument().getItemValueString("$blobworkitem").isEmpty() && (lobWorkitem = this.documentService.load(documentEvent.getDocument().getItemValueString("$blobworkitem"))) != null) {
            logger.info("delete deprecated blobworkitem: '" + documentEvent.getDocument().getItemValueString("$blobworkitem") + "'");
            this.documentService.remove(lobWorkitem);
        }
        List<ItemCollection> snappshotList = this.findAllSnapshots(documentEvent.getDocument().getUniqueID());
        for (ItemCollection snapshot : snappshotList) {
            this.documentService.remove(snapshot);
        }
    }

    public List<ItemCollection> findAllSnapshots(String uniqueid) {
        if (uniqueid == null || uniqueid.isEmpty()) {
            throw new SnapshotException("INVALID_UNIQUEID", "undefined $uniqueid");
        }
        String query = "SELECT document FROM Document AS document WHERE document.id > '" + uniqueid + "-' AND document.id < '" + uniqueid + "-9999999999999' ORDER BY document.id DESC";
        return this.documentService.getDocumentsByQuery(query, 999);
    }

    public FileData getWorkItemFile(String uniqueid, String file) {
        ItemCollection workItem = this.documentService.load(uniqueid);
        String snapshotID = workItem.getItemValueString(SNAPSHOTID);
        ItemCollection snapshot = this.documentService.load(snapshotID);
        if (snapshot != null) {
            return snapshot.getFileData(file);
        }
        return null;
    }

    void cleanSnaphostHistory(String snapshotID) {
        if (snapshotID == null || snapshotID.isEmpty()) {
            throw new SnapshotException("INVALID_UNIQUEID", "invalid $snapshotid");
        }
        int iSnapshotHistory = 1;
        try {
            iSnapshotHistory = Integer.parseInt(this.propertyService.getProperties().getProperty(PROPERTY_SNAPSHOT_HISTORY, "1"));
        }
        catch (NumberFormatException nfe) {
            throw new SnapshotException("INVALID_PARAMETER", "imixs.properties 'snapshot.history' must be a integer value.");
        }
        logger.fine("snapshot.history = " + iSnapshotHistory);
        if (iSnapshotHistory == 0) {
            return;
        }
        logger.fine("cleanSnaphostHistory for $snapshotid: " + snapshotID);
        String snapshtIDPfafix = snapshotID.substring(0, snapshotID.lastIndexOf(45));
        String query = "SELECT document FROM Document AS document WHERE document.id > '" + snapshtIDPfafix + "-' AND document.id < '" + snapshotID + "' ORDER BY document.id ASC";
        List result = this.documentService.getDocumentsByQuery(query);
        while (result.size() >= iSnapshotHistory) {
            ItemCollection oldSnapshot = (ItemCollection)result.get(0);
            logger.fine("remove deprecated snapshot: " + oldSnapshot.getUniqueID());
            try {
                this.documentService.remove(oldSnapshot);
            }
            catch (AccessDeniedException e) {
                logger.warning("remove deprecated snapshot '" + snapshotID + "' failed: " + e.getMessage());
            }
            result.remove(0);
        }
    }

    private void copyFilesFromItemCollection(ItemCollection source, ItemCollection target, ItemCollection origin, boolean overwriteFileContent, boolean blobWorkitem) {
        List files = target.getFileData();
        for (FileData fileData : files) {
            FileData oldFileData;
            String fileName = fileData.getName();
            byte[] content = fileData.getContent();
            if (content.length == 0 || blobWorkitem && content.length <= 2) {
                if (source != null) {
                    oldFileData = source.getFileData(fileName);
                    if (oldFileData != null) {
                        logger.fine("copy file content '" + fileName + "' from: " + source.getUniqueID());
                        target.addFileData(new FileData(fileName, oldFileData.getContent(), oldFileData.getContentType(), oldFileData.getAttributes()));
                        continue;
                    }
                    logger.warning("Missing file content!");
                    continue;
                }
                logger.warning("Missing file content!");
                continue;
            }
            if (overwriteFileContent || (oldFileData = source.getFileData(fileName)) == null) continue;
            ItemCollection dmsColOrigin = new ItemCollection(fileData.getAttributes());
            ItemCollection dmsColOld = new ItemCollection(oldFileData.getAttributes());
            if (dmsColOrigin == null || dmsColOld == null || dmsColOrigin.getItemValueString(ITEM_MD5_CHECKSUM).equals(dmsColOld.getItemValueString(ITEM_MD5_CHECKSUM))) continue;
            Date fileDate = dmsColOld.getItemValueDate("$modified");
            if (fileDate == null) {
                fileDate = dmsColOld.getItemValueDate("$created");
            }
            if (fileDate == null) {
                fileDate = new Date();
            }
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("[yyyy-MM-dd'T'HH:mm:ss.SSS'Z']");
            df.setTimeZone(tz);
            String sTimeStamp = df.format(fileDate);
            String protectedFileName = null;
            int iFileDot = fileName.lastIndexOf(46);
            protectedFileName = iFileDot > 0 ? fileName.substring(0, iFileDot) + "-" + sTimeStamp + fileName.substring(iFileDot) : fileName + "-" + sTimeStamp;
            byte[] empty = new byte[]{};
            dmsColOld.replaceItemValue("txtname", (Object)protectedFileName);
            target.addFileData(new FileData(protectedFileName, oldFileData.getContent(), oldFileData.getContentType(), dmsColOld.getAllItems()));
            origin.addFileData(new FileData(protectedFileName, empty, oldFileData.getContentType(), dmsColOld.getAllItems()));
        }
    }

    private void updateCustomAttributes(ItemCollection workitem, String username) throws NoSuchAlgorithmException {
        List currentFileData = workitem.getFileData();
        String customContent = "";
        for (FileData fileData : currentFileData) {
            ItemCollection customAtributes = new ItemCollection(fileData.getAttributes());
            if (fileData.getContent() != null && fileData.getContent().length > 1) {
                String oldChecksum = customAtributes.getItemValueString(ITEM_MD5_CHECKSUM);
                String newChecksum = fileData.generateMD5();
                customAtributes.replaceItemValue(ITEM_MD5_CHECKSUM, (Object)newChecksum);
                customAtributes.replaceItemValue("size", (Object)fileData.getContent().length);
                customAtributes.replaceItemValue("txtname", (Object)fileData.getName());
                if (!oldChecksum.isEmpty() && !oldChecksum.equals(newChecksum)) {
                    customAtributes.replaceItemValue("$modified", (Object)new Date());
                    customAtributes.replaceItemValue("$editor", (Object)username);
                } else {
                    customAtributes.replaceItemValue("$created", (Object)new Date());
                    customAtributes.replaceItemValue("$creator", (Object)username);
                    customAtributes.replaceItemValue("namcreator", (Object)username);
                }
                fileData.setAttributes(customAtributes.getAllItems());
                workitem.addFileData(fileData);
            }
            customContent = customContent + customAtributes.getItemValueString("content");
            customContent = customContent + " ";
        }
        workitem.replaceItemValue(ITEM_DMS_FILE_COUNT, (Object)workitem.getFileNames().size());
        workitem.replaceItemValue(ITEM_DMS_FILE_NAMES, (Object)workitem.getFileNames());
        workitem.replaceItemValue(ITEM_DMS, (Object)customContent);
    }
}

