/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.maven.manik;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.imixs.maven.manik.HotDeployment;
import org.imixs.maven.manik.MojoAutodeployPlugin;

@Mojo(name="hotdeploy", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class MojoHotdeployPlugin
extends AbstractMojo {
    public static final String SEPARATOR = FileSystems.getDefault().getSeparator();
    @Parameter(property="hotdeployments", alias="hotdeploy.hotdeployments", required=true)
    protected List<HotDeployment> hotdeployments;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private WatchService watcher;
    private Map<WatchKey, HotDeployment> watchKeyMap;

    public void execute() throws MojoExecutionException, MojoFailureException {
        int count = 0;
        this.watchKeyMap = new HashMap<WatchKey, HotDeployment>();
        Path basePath = this.project.getBasedir().toPath();
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create watch service");
        }
        if (this.hotdeployments.size() > 0) {
            for (HotDeployment deployment : this.hotdeployments) {
                Path sourcePath = MojoAutodeployPlugin.getSourcePath(deployment, basePath);
                Path targetPath = MojoAutodeployPlugin.getTargetPath(deployment, basePath);
                this.getLog().info((CharSequence)("..... source: " + sourcePath.toString()));
                this.getLog().info((CharSequence)("..... target: " + targetPath.toString()));
                try {
                    this.registerRecursive(sourcePath, deployment);
                }
                catch (IOException x) {
                    System.err.println(x);
                }
            }
        }
        this.getLog().info((CharSequence)"..... watching hot-deployments...");
        try {
            WatchKey key;
            boolean valid;
            do {
                try {
                    key = this.watcher.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                HotDeployment watchKeyDeployment = this.watchKeyMap.get(key);
                Path targetPath = MojoAutodeployPlugin.getTargetPath(watchKeyDeployment, basePath);
                Path sourcePath = MojoAutodeployPlugin.getSourcePath(watchKeyDeployment, basePath);
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    ++count;
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    Path absoluteSourcePath = Paths.get(watchKeyDeployment.getObjectPath() + SEPARATOR + filename.toString(), new String[0]);
                    Path relativePath = sourcePath.relativize(absoluteSourcePath);
                    Path absoluteTargetPath = Paths.get(targetPath + SEPARATOR + relativePath, new String[0]);
                    if (event.kind().equals(StandardWatchEventKinds.ENTRY_CREATE) || event.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
                        Files.copy(absoluteSourcePath, absoluteTargetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (event.kind().equals(StandardWatchEventKinds.ENTRY_DELETE)) {
                        Files.deleteIfExists(absoluteTargetPath);
                    }
                    this.getLog().info((CharSequence)("...(" + count + ") " + event.kind() + ": " + relativePath));
                }
            } while (valid = key.reset());
        }
        catch (IOException | ClosedWatchServiceException e) {
            this.getLog().error((CharSequence)("Failed to process Hot Deployment: " + e.getMessage()));
        }
    }

    private void registerRecursive(Path root, final HotDeployment deployment) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatchKey key = dir.register(MojoHotdeployPlugin.this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                HotDeployment currentDeployment = new HotDeployment(deployment.getSource(), deployment.getTarget());
                currentDeployment.setObjectPath(dir.toString());
                MojoHotdeployPlugin.this.watchKeyMap.put(key, currentDeployment);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

