/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.maven.manik;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.imixs.maven.manik.AbstractDeployment;
import org.imixs.maven.manik.AutoDeployment;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class MojoAutodeployPlugin
extends AbstractMojo {
    @Parameter(property="autodeployments", alias="hotdeploy.autodeployments", required=true)
    protected List<AutoDeployment> autodeployments;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    FileSet fileset;

    public void execute() throws MojoExecutionException, MojoFailureException {
        int count = 0;
        Path basePath = this.project.getBasedir().toPath();
        if (this.autodeployments.size() > 0) {
            this.getLog().info((CharSequence)"Starting auto deployment....");
            for (AutoDeployment deployment : this.autodeployments) {
                Path sourcePath = MojoAutodeployPlugin.getSourcePath(deployment, basePath);
                Path targetPath = MojoAutodeployPlugin.getTargetPath(deployment, basePath);
                this.getLog().info((CharSequence)("..... source: " + sourcePath.toString()));
                this.getLog().info((CharSequence)("..... target: " + targetPath.toString()));
                try {
                    DirectoryStream<Path> stream = Files.newDirectoryStream(sourcePath.getParent(), sourcePath.getFileName().toString());
                    for (Path path : stream) {
                        this.copyArtefact(path, targetPath.resolve(path.getFileName()), deployment.isUnpack());
                        ++count;
                    }
                    stream.close();
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Failed to copy target file: " + e.getMessage()));
                }
                this.getLog().info((CharSequence)(count + " auto-deployments completed."));
            }
        } else {
            this.getLog().info((CharSequence)"No auto-deployments defined");
        }
    }

    public static Path getSourcePath(AbstractDeployment deployment, Path basePath) {
        Path source = Paths.get(deployment.getSource(), new String[0]);
        if (!source.isAbsolute()) {
            source = basePath.resolve(source);
        }
        return source;
    }

    public static Path getTargetPath(AbstractDeployment deployment, Path basePath) {
        Path target = Paths.get(deployment.getTarget(), new String[0]);
        if (!target.isAbsolute()) {
            target = basePath.resolve(target);
        }
        return target;
    }

    public void copyArtefact(Path path, Path targetPath, boolean unpack) throws IOException {
        if (new File(path.toString()).isDirectory()) {
            this.getLog().info((CharSequence)"..... WARNING - artifact is an directory - deployment skipped");
        } else {
            this.getLog().info((CharSequence)("..... deploy: " + path.toString() + " : unpack=" + unpack));
            if (!unpack) {
                Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                this.unzipArtifact(path.toString(), targetPath.toString());
                this.touchFile(targetPath.getParent().toString() + "/" + path.getFileName() + ".dodeploy");
            }
        }
    }

    private void touchFile(String path) throws IOException {
        File doDeployFile = new File(path);
        if (!doDeployFile.exists()) {
            doDeployFile.createNewFile();
        }
    }

    private void unzipArtifact(String fileZip, String target) throws IOException {
        File destDir = new File(target);
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(fileZip));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = this.newFile(destDir, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
    }

    private File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

