/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.op;

import it.tidalwave.image.ImageUtils;
import it.tidalwave.image.op.Operation;
import java.awt.color.ICC_Profile;
import java.beans.ConstructorProperties;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConvertColorProfileOp
extends Operation {
    @Nonnull
    private final ICC_Profile iccProfile;
    @Nonnull
    private final RenderingIntent renderingIntent;

    public ConvertColorProfileOp(@Nonnull ICC_Profile iccProfile) {
        this(iccProfile, RenderingIntent.PERCEPTUAL);
    }

    @Nonnull
    public String toString() {
        return String.format("ConvertColorProfileOp(%s, %s)", new Object[]{ImageUtils.getICCProfileName((ICC_Profile)this.iccProfile), this.renderingIntent});
    }

    @ConstructorProperties(value={"iccProfile", "renderingIntent"})
    public ConvertColorProfileOp(@Nonnull ICC_Profile iccProfile, @Nonnull RenderingIntent renderingIntent) {
        if (iccProfile == null) {
            throw new NullPointerException("iccProfile");
        }
        if (renderingIntent == null) {
            throw new NullPointerException("renderingIntent");
        }
        this.iccProfile = iccProfile;
        this.renderingIntent = renderingIntent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertColorProfileOp)) {
            return false;
        }
        ConvertColorProfileOp other = (ConvertColorProfileOp)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getIccProfile() == null ? other.getIccProfile() != null : !this.getIccProfile().equals(other.getIccProfile())) {
            return false;
        }
        return !(this.getRenderingIntent() == null ? other.getRenderingIntent() != null : !this.getRenderingIntent().equals((Object)other.getRenderingIntent()));
    }

    public boolean canEqual(Object other) {
        return other instanceof ConvertColorProfileOp;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + (this.getIccProfile() == null ? 0 : this.getIccProfile().hashCode());
        result = result * 31 + (this.getRenderingIntent() == null ? 0 : this.getRenderingIntent().hashCode());
        return result;
    }

    @Nonnull
    public ICC_Profile getIccProfile() {
        return this.iccProfile;
    }

    @Nonnull
    public RenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    public static enum RenderingIntent {
        ABSOLUTE,
        RELATIVE_COLORIMETRIC,
        PERCEPTUAL,
        SATURATION;

    }
}

