/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.ImageUtils;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.ConvertColorProfileOp;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.RenderingHints;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ConvertColorProfileJ2DOp
extends OperationImplementation<ConvertColorProfileOp, BufferedImage> {
    private static final Logger log = LoggerFactory.getLogger(ConvertColorProfileJ2DOp.class);

    @Nonnull
    protected BufferedImage execute(@Nonnull ConvertColorProfileOp operation, @Nonnull EditableImage image, @Nonnull BufferedImage bufferedImage) {
        ICC_Profile targetProfile = operation.getIccProfile();
        log.debug("convertColorProfile({})", (Object)ImageUtils.getICCProfileName((ICC_Profile)targetProfile));
        Java2DUtils.logImage((Logger)log, (String)">>>> source bufferedImage", (RenderedImage)bufferedImage);
        ICC_Profile sourceProfile = ImageUtils.getICCProfile((RenderedImage)bufferedImage);
        String sourceProfileName = ImageUtils.getICCProfileName((ICC_Profile)sourceProfile);
        log.debug(">>>> Converting profile from {}  to {}", (Object)sourceProfileName, (Object)ImageUtils.getICCProfileName((ICC_Profile)targetProfile));
        RenderingHints hints = new RenderingHints(Collections.emptyMap());
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        ColorConvertOp ccOp = new ColorConvertOp(new ICC_Profile[]{targetProfile}, hints);
        log.warn(">>>> **** WARNING: convertColorProfile() is reducing depth to 8 bit!");
        WritableRaster raster = Raster.createPackedRaster(3, bufferedImage.getWidth(), bufferedImage.getHeight(), 3, 8, null);
        ICC_ColorSpace colorSpace = new ICC_ColorSpace(targetProfile);
        DirectColorModel colorModel = new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
        BufferedImage image2 = new BufferedImage(colorModel, raster, false, Java2DUtils.getProperties((BufferedImage)bufferedImage));
        BufferedImage result = ccOp.filter(bufferedImage, image2);
        Java2DUtils.logImage((Logger)log, (String)">>>> >>>> convertColorProfile() returning ", (RenderedImage)result);
        return result;
    }
}

