/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.render;

import java.awt.Point;
import org.imajine.image.render.EditableImageRenderer;

public class ScaleController {
    protected final EditableImageRenderer imageRenderer;
    private double zoomFactor = 1.5;

    public ScaleController(EditableImageRenderer imageRenderer) {
        if (imageRenderer == null) {
            throw new IllegalArgumentException("imageRenderer is mandatory");
        }
        this.imageRenderer = imageRenderer;
    }

    public final void setScale(double scale) {
        this.setScale(scale, null);
    }

    public void setScale(double scale, Point pivot) {
        this.imageRenderer.setScale(scale, pivot);
    }

    public double getScale() {
        return this.imageRenderer.getScale();
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void fitToView() {
        this.fitToView(1.0);
    }

    public void fitToView(double factor) {
        this.imageRenderer.setRepaintEnabled(false);
        this.imageRenderer.centerImage();
        this.setScale(this.imageRenderer.getFitScale() * factor);
        this.imageRenderer.setRepaintEnabled(true);
        this.imageRenderer.repaint();
    }

    public void zoomOut() {
        this.setScale(this.imageRenderer.getScale() / this.zoomFactor);
    }

    public void zoomIn() {
        this.setScale(this.imageRenderer.getScale() * this.zoomFactor);
    }

    public void showActualPixels() {
        this.setScale(1.0);
    }

    protected EditableImageRenderer getImageRenderer() {
        return this.imageRenderer;
    }
}

