/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.render;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.imajine.image.render.EditableImageRenderer;
import org.imajine.image.render.ScaleController;

public class MouseWheelZoomingController {
    private final EditableImageRenderer imageRenderer;
    private final ScaleController scaleController;
    private boolean enabled;
    private double zoomFactor = 0.25;
    private final MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            double changeScale = Math.pow(2.0, MouseWheelZoomingController.this.zoomFactor * (double)event.getWheelRotation());
            MouseWheelZoomingController.this.scaleController.setScale(MouseWheelZoomingController.this.scaleController.getScale() * changeScale);
        }
    };

    public MouseWheelZoomingController(ScaleController scaleController) {
        if (scaleController == null) {
            throw new IllegalArgumentException("scaleController is mandatory");
        }
        this.scaleController = scaleController;
        this.imageRenderer = scaleController.getImageRenderer();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.imageRenderer.addMouseWheelListener(this.mouseWheelListener);
            } else {
                this.imageRenderer.removeMouseWheelListener(this.mouseWheelListener);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }
}

