/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.render;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.imajine.image.render.EditableImageRenderer;
import org.imajine.image.render.ScaleController;
import org.imajine.image.render.event.EditableImageRendererAdapter;
import org.imajine.image.render.event.EditableImageRendererEvent;

public class MouseClickZoomingController {
    private final EditableImageRenderer imageRenderer;
    private final ScaleController scaleController;
    private boolean enabled;
    private int clickCountToZoom = 2;
    private double factor = 1.0;
    private final EditableImageRendererAdapter scaleListener = new EditableImageRendererAdapter(){

        @Override
        public void scaleChanged(EditableImageRendererEvent editableImageRendererEvent) {
            double scale = MouseClickZoomingController.this.imageRenderer.getScale();
            MouseClickZoomingController.this.imageRenderer.setCursor(Cursor.getPredefinedCursor(scale != MouseClickZoomingController.this.imageRenderer.getFitScale() ? 12 : 1));
        }
    };
    private final MouseListener clickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == MouseClickZoomingController.this.clickCountToZoom && MouseClickZoomingController.this.imageRenderer.getPositionOverImage(event.getPoint()) != null) {
                double scale = MouseClickZoomingController.this.imageRenderer.getScale();
                MouseClickZoomingController.this.scaleController.setScale(scale == 1.0 ? MouseClickZoomingController.this.imageRenderer.getFitScale() * MouseClickZoomingController.this.factor : 1.0, event.getPoint());
            }
        }
    };

    public MouseClickZoomingController(ScaleController scaleController) {
        if (scaleController == null) {
            throw new IllegalArgumentException("scaleController is mandatory");
        }
        this.scaleController = scaleController;
        this.imageRenderer = scaleController.getImageRenderer();
    }

    public void setClickCountToZoom(int clickCountToZoom) {
        this.clickCountToZoom = clickCountToZoom;
    }

    public int getClickCountToZoom() {
        return this.clickCountToZoom;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.imageRenderer.addMouseListener(this.clickListener);
                this.imageRenderer.addImageRendererListener(this.scaleListener);
            } else {
                this.imageRenderer.removeMouseListener(this.clickListener);
                this.imageRenderer.removeImageRendererListener(this.scaleListener);
                this.imageRenderer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public double getFactor() {
        return this.factor;
    }
}

