/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.render;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.imajine.image.render.EditableImageRenderer;
import org.imajine.image.render.Overlay;

public class EditingTool
implements MouseListener,
MouseMotionListener,
KeyListener,
Overlay {
    public static final String CHANGED_ATTRIBUTE = EditingTool.class.getName() + ".changed";
    protected final EditableImageRenderer imageRenderer;
    private final Map<Class<? extends State>, State> stateMap = new HashMap<Class<? extends State>, State>();
    private final State NULL_STATE;
    private State state = this.NULL_STATE = new State();
    private Class<? extends State> initialState;
    private boolean active = false;
    private boolean oneShot = false;
    private Icon icon;
    private final JToggleButton.ToggleButtonModel buttonModel = new JToggleButton.ToggleButtonModel();
    private final Action action = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!EditingTool.this.active) {
                EditingTool.this.activate();
            } else {
                EditingTool.this.deactivate();
            }
        }
    };

    protected EditingTool(EditableImageRenderer imageRenderer) {
        this.imageRenderer = imageRenderer;
    }

    public void setEnabled(boolean enabled) {
        this.action.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.action.isEnabled();
    }

    public boolean isActive() {
        return this.active;
    }

    public void commitChanges() {
    }

    public void activate() {
        if (this.active) {
            throw new IllegalStateException("Already active");
        }
        if (this.imageRenderer.editingTool != null) {
            this.imageRenderer.editingTool.deactivate();
        }
        this.active = true;
        this.buttonModel.setSelected(true);
        this.setState(this.initialState);
        this.imageRenderer.addMouseListener(this);
        this.imageRenderer.addMouseMotionListener(this);
        this.imageRenderer.addKeyListener(this);
        this.imageRenderer.addOverlay(this);
        this.imageRenderer.setCursor(this.makeCursor(this.icon, "xxx"));
        this.imageRenderer.fireEditingToolActivated(this);
        this.imageRenderer.editingTool = this;
    }

    public void deactivate() {
        if (!this.active) {
            throw new IllegalStateException("Not active");
        }
        this.active = false;
        this.buttonModel.setSelected(false);
        this.imageRenderer.removeMouseListener(this);
        this.imageRenderer.removeMouseMotionListener(this);
        this.imageRenderer.removeKeyListener(this);
        this.imageRenderer.removeOverlay(this);
        this.imageRenderer.repaint();
        this.imageRenderer.setCursor(null);
        this.imageRenderer.fireEditingToolDeactivated(this);
        this.imageRenderer.editingTool = null;
    }

    public void imageChanged() {
        this.deactivate();
    }

    public void reset() {
        if (this.oneShot) {
            this.deactivate();
        } else {
            this.imageRenderer.repaint();
            this.setState(this.initialState);
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.action.putValue("SmallIcon", icon);
    }

    @Override
    public final boolean isVisible() {
        return true;
    }

    public void connectButton(JToggleButton button) {
        this.action.putValue("ShortDescription", button.getToolTipText());
        button.setAction(this.action);
        button.setModel(this.buttonModel);
    }

    protected void setInitialState(Class<? extends State> initialStateClass) {
        this.initialState = initialStateClass;
    }

    protected void setState(Class<? extends State> newStateClass) {
        State newState;
        if (this.state != null) {
            this.state.stop();
        }
        if ((newState = this.stateMap.get(newStateClass)) == null) {
            throw new IllegalArgumentException("Invalid or unregistered state: " + newStateClass);
        }
        this.state = newState;
        this.state.start();
        System.err.println("CURRENT STATE: " + this.state);
    }

    protected State getCurrentState() {
        return this.state;
    }

    protected void registerState(State state) {
        this.stateMap.put(state.getClass(), state);
    }

    protected void repaint() {
        this.imageRenderer.repaint();
    }

    protected Cursor makeCursor(Icon icon, String name) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = ((ImageIcon)icon).getImage();
        return toolkit.createCustomCursor(image, new Point(0, 0), name);
    }

    @Override
    public final void mouseClicked(MouseEvent event) {
        this.state.mouseClicked(event);
    }

    @Override
    public final void mousePressed(MouseEvent event) {
        this.state.mousePressed(event);
    }

    @Override
    public final void mouseReleased(MouseEvent event) {
        this.state.mouseReleased(event);
    }

    @Override
    public final void mouseEntered(MouseEvent event) {
        this.state.mouseEntered(event);
    }

    @Override
    public final void mouseExited(MouseEvent event) {
        this.state.mouseExited(event);
    }

    @Override
    public final void mouseDragged(MouseEvent event) {
        this.state.mouseDragged(event);
    }

    @Override
    public final void mouseMoved(MouseEvent event) {
        this.state.mouseMoved(event);
    }

    @Override
    public final void keyTyped(KeyEvent event) {
        this.state.keyTyped(event);
    }

    @Override
    public final void keyPressed(KeyEvent event) {
        this.state.keyPressed(event);
    }

    @Override
    public final void keyReleased(KeyEvent event) {
        this.state.keyReleased(event);
    }

    @Override
    public final void paint(Graphics2D g, EditableImageRenderer imageRenderer) {
        this.state.paint(g, imageRenderer);
    }

    public class State {
        public void mouseClicked(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseMoved(MouseEvent event) {
        }

        public void keyTyped(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 27) {
                EditingTool.this.deactivate();
            }
        }

        public void keyReleased(KeyEvent event) {
            System.err.println("EVENT " + event);
        }

        public void paint(Graphics2D g, EditableImageRenderer imageRenderer) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

