/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.render;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.Border;
import org.imajine.image.EditableImage;
import org.imajine.image.Quality;
import org.imajine.image.op.Operation;
import org.imajine.image.op.OptimizeOp;
import org.imajine.image.op.PaintOp;
import org.imajine.image.op.RotateOp;
import org.imajine.image.op.ScaleOp;
import org.imajine.image.render.EditingTool;
import org.imajine.image.render.Overlay;
import org.imajine.image.render.PreviewSettings;
import org.imajine.image.render.event.EditableImageRendererEvent;
import org.imajine.image.render.event.EditableImageRendererListener;
import org.imajine.image.util.Platform;

public class EditableImageRenderer
extends JComponent {
    private static final String CLASS = EditableImageRenderer.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    public static final double MAX_SCALE = 40.0;
    public static final double MIN_SCALE = 0.01;
    private static final int MAX_SIZE_FOR_SCALED_CACHING = 8000;
    private static final Color DEFAULT_BACKGROUND = Color.DARK_GRAY;
    private static final Insets NULL_MARGIN = new Insets(0, 0, 0, 0);
    protected EditableImage image;
    private EditableImage optimizedImage;
    private EditableImage scaledImage;
    private boolean optimizedImageEnabled;
    private boolean scaledImageCachingEnabled;
    protected double scale = 1.0;
    private double minScale = 0.01;
    private double maxScale = 40.0;
    protected double angle = 0.0;
    private Point origin = new Point(0, 0);
    private PreviewSettings previewSettings;
    private int shownImageX;
    private int shownImageY;
    private int shownImageWidth;
    private int shownImageHeight;
    private Insets margin = new Insets(0, 0, 0, 0);
    private Shape clippingShape;
    private Quality scaleQuality = Quality.INTERMEDIATE;
    private Quality rotateQuality = Quality.INTERMEDIATE;
    private final List<Overlay> overlayList = new ArrayList<Overlay>();
    private boolean fitToDisplaySize;
    private final List<EditableImageRendererListener> listenerList = new ArrayList<EditableImageRendererListener>();
    private boolean repaintEnabled = true;
    protected EditingTool editingTool;
    private final JScrollBar horizontalScrollBar = new JScrollBar(0);
    private final JScrollBar verticalScrollBar = new JScrollBar(1);
    private final JPanel filler = new JPanel();
    private boolean scrollBarsVisible = false;
    private Border imageBorder;
    private int previousWidth;
    private int previohsHeight;
    private int scrollbarThickness = 16;
    private final AdjustmentListener scrollbarListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            EditableImageRenderer.this.setOrigin(new Point(EditableImageRenderer.this.horizontalScrollBar.getValue(), EditableImageRenderer.this.verticalScrollBar.getValue()));
        }
    };

    public EditableImageRenderer() {
        boolean workaroundMST63;
        this.setBackground(DEFAULT_BACKGROUND);
        this.setLayout(null);
        this.setOpaque(false);
        boolean bl = workaroundMST63 = !Platform.isMacOSX();
        if (workaroundMST63) {
            logger.warning("Enabled workaround for MST-63");
        }
        this.setScaledImageCachingEnabled(workaroundMST63);
        this.setOptimizedImageEnabled(workaroundMST63);
        this.add(this.horizontalScrollBar);
        this.add(this.verticalScrollBar);
        this.add(this.filler);
        this.horizontalScrollBar.addAdjustmentListener(this.scrollbarListener);
        this.verticalScrollBar.addAdjustmentListener(this.scrollbarListener);
        this.horizontalScrollBar.setVisible(this.scrollBarsVisible);
        this.verticalScrollBar.setVisible(this.scrollBarsVisible);
        this.filler.setVisible(this.scrollBarsVisible);
    }

    public void setImage(EditableImage image) {
        logger.info("setImage(" + image + ")");
        if (image == null) {
            this.image = null;
            logger.warning("setImage(null)");
        } else {
            this.image = image;
        }
        if (this.editingTool != null) {
            this.editingTool.imageChanged();
        }
        this.flushAllCaches();
        this.updateScrollBars();
        if (this.fitToDisplaySize) {
            this.fitToDisplaySize();
        } else {
            this.repaint();
        }
    }

    public EditableImage getImage() {
        return this.image;
    }

    public EditableImage getOptimizedImage() {
        return this.optimizedImage;
    }

    public void setRepaintEnabled(boolean repaintEnabled) {
        logger.info("setRepaintEnabled(" + repaintEnabled + ")");
        this.repaintEnabled = repaintEnabled;
    }

    public boolean isRepaintEnabled() {
        return this.repaintEnabled;
    }

    public void setOrigin(Point origin) {
        logger.info("setOrigin(" + origin + ")");
        if (this.image != null && this.image.getWidth() > 0 && this.image.getHeight() > 0) {
            this.internalSetOrigin(origin);
            this.updateScrollBars();
            this.repaint();
        }
    }

    private void internalSetOrigin(Point origin) {
        logger.info("internalSetOrigin(" + origin + ")");
        int maxWidth = (int)Math.round((double)this.getAvailableWidth() / this.scale);
        int maxHeight = (int)Math.round((double)this.getAvailableHeight() / this.scale);
        int widthWithMargin = this.image.getWidth() + this.margin.left + this.margin.right;
        int heightWithMargin = this.image.getHeight() + this.margin.top + this.margin.bottom;
        int xMin = -this.margin.left;
        int yMin = -this.margin.top;
        int xMax = this.image.getWidth() + this.margin.right - maxWidth;
        int yMax = this.image.getHeight() + this.margin.bottom - maxHeight;
        this.origin.x = maxWidth <= widthWithMargin ? Math.min(Math.max(xMin, origin.x), xMax) : -(maxWidth - this.image.getWidth()) / 2;
        this.origin.y = maxHeight <= heightWithMargin ? Math.min(Math.max(yMin, origin.y), yMax) : -(maxHeight - this.image.getHeight()) / 2;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public double getScale() {
        return this.scale;
    }

    public void setAngle(double angle) {
        logger.info("setAngle(" + angle + ")");
        if (this.angle != angle) {
            this.angle = angle;
            this.flushScaledImageCache();
            this.repaint();
            this.fireAngleChangedEvent();
        }
    }

    public double getAngle() {
        return this.angle;
    }

    public EditingTool getEditingTool() {
        return this.editingTool;
    }

    public void setImageBorder(Border imageBorder) {
        this.imageBorder = imageBorder;
    }

    public Border getImageBorder() {
        return this.imageBorder;
    }

    public Point getPositionOverImage(Point componentPoint) {
        if (this.image == null) {
            return null;
        }
        int imageWidth = this.image.getWidth();
        int imageHeight = this.image.getHeight();
        if (imageWidth == 0 || imageHeight == 0) {
            return null;
        }
        if (this.shownImageWidth == 0 || this.shownImageHeight == 0) {
            logger.severe("Image size: " + this.shownImageHeight + " x " + this.shownImageHeight);
            return null;
        }
        int x = (componentPoint.x - this.shownImageX) * imageWidth / this.shownImageWidth;
        int y = (componentPoint.y - this.shownImageY) * imageHeight / this.shownImageHeight;
        if (x >= 0 && y >= 0 && x < imageWidth && y < imageHeight) {
            return new Point(x, y);
        }
        return null;
    }

    public Point convertImagePointToComponentPoint(Point imagePoint) {
        if (this.image == null) {
            return null;
        }
        int imageWidth = this.image.getWidth();
        int imageHeight = this.image.getHeight();
        if (imageWidth == 0 || imageHeight == 0) {
            return null;
        }
        if (this.shownImageWidth == 0 || this.shownImageHeight == 0) {
            logger.severe("Image size: " + this.shownImageHeight + " x " + this.shownImageHeight);
            return null;
        }
        int x = imagePoint.x * this.shownImageWidth / imageWidth + this.shownImageX;
        int y = imagePoint.y * this.shownImageHeight / imageHeight + this.shownImageY;
        return new Point(x, y);
    }

    public void setPositionOverImage(Point imagePoint, Point componentPoint) {
        logger.info("setPositionOverImage(" + imagePoint + ", " + componentPoint + ")");
        Point newOrigin = this.computeOrigin(imagePoint, componentPoint, this.scale);
        if (newOrigin != null) {
            this.setOrigin(newOrigin);
        }
    }

    public void setMargin(Insets margin) {
        logger.info("setMargin(" + margin + ")");
        this.margin = (Insets)margin.clone();
    }

    public Insets getMargin() {
        return (Insets)this.margin.clone();
    }

    public void setScrollBarsVisible(boolean scrollBarsVisible) {
        logger.info("setScrollBarsVisible(" + scrollBarsVisible + ")");
        if (this.scrollBarsVisible != scrollBarsVisible) {
            this.scrollBarsVisible = scrollBarsVisible;
            if (scrollBarsVisible) {
                this.previohsHeight = -1;
                this.previousWidth = -1;
                this.updateScrollBars();
            }
            this.horizontalScrollBar.setVisible(scrollBarsVisible);
            this.verticalScrollBar.setVisible(scrollBarsVisible);
            this.filler.setVisible(scrollBarsVisible);
            this.repaint();
        }
    }

    public boolean isScrollBarsVisible() {
        return this.scrollBarsVisible;
    }

    protected Point computeOrigin(Point imagePoint, Point componentPoint, double scale) {
        if (this.image == null) {
            return null;
        }
        int imageWidth = this.image.getWidth();
        int imageHeight = this.image.getHeight();
        if (imageWidth == 0 || imageHeight == 0) {
            return null;
        }
        return new Point((int)Math.round((double)imagePoint.x - (double)componentPoint.x / scale), (int)Math.round((double)imagePoint.y - (double)componentPoint.y / scale));
    }

    public void setScaleQuality(Quality scaleQuality) {
        logger.info("setScaleQuality(" + scaleQuality + ")");
        if (this.scaleQuality != scaleQuality) {
            this.scaleQuality = scaleQuality;
            this.flushScaledImageCache();
        }
    }

    public Quality getScaleQuality() {
        return this.scaleQuality;
    }

    public void setRotateQuality(Quality rotateQuality) {
        logger.info("setRotateQuality(" + rotateQuality + ")");
        if (this.rotateQuality != rotateQuality) {
            this.rotateQuality = rotateQuality;
            this.flushScaledImageCache();
        }
    }

    public Quality getRotateQuality() {
        return this.rotateQuality;
    }

    public void setScaledImageCachingEnabled(boolean scaledImageCachingEnabled) {
        logger.info("setScaledImageCachingEnabled(" + scaledImageCachingEnabled + ")");
        this.scaledImageCachingEnabled = scaledImageCachingEnabled;
        if (!scaledImageCachingEnabled) {
            this.flushScaledImageCache();
        }
    }

    public boolean isScaledImageCachingEnabled() {
        return this.scaledImageCachingEnabled;
    }

    public void setOptimizedImageEnabled(boolean optimizedImageEnabled) {
        logger.info("setOptimizedImageEnabled(" + optimizedImageEnabled + ")");
        this.optimizedImageEnabled = optimizedImageEnabled;
    }

    public boolean isOptimizedImageEnabled() {
        return this.optimizedImageEnabled;
    }

    public void setClippingShape(Shape clippingShape) {
        this.clippingShape = clippingShape;
    }

    public void addOverlay(Overlay overlay) {
        this.overlayList.add(overlay);
    }

    public void removeOverlay(Overlay overlay) {
        this.overlayList.remove(overlay);
    }

    public void setPreviewSettings(PreviewSettings previewSettings) {
        this.previewSettings = previewSettings;
        this.repaint();
    }

    public PreviewSettings getPreviewSettings() {
        return this.previewSettings;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        logger.info("paint()");
        if (!this.repaintEnabled) {
            return;
        }
        if (this.fitToDisplaySize) {
            this.internalSetScale(this.getFitScale());
            this.internalSetOrigin(this.computeCenterPoint());
        }
        this.layoutScrollBars();
        int myWidth = this.getWidth();
        int myHeight = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, myWidth, myHeight);
        Graphics g2 = null;
        try {
            if (this.image != null) {
                EditableImage imageToDraw = null;
                double maxSize = this.scale * (double)Math.max(this.image.getWidth(), this.image.getHeight());
                boolean needScaling = true;
                int rotationDeltaX = 0;
                int rotationDeltaY = 0;
                if (this.scaledImageCachingEnabled && maxSize < 8000.0 || this.angle != 0.0) {
                    if (this.scaledImage == null) {
                        logger.fine(">>>> computing scaled image");
                        this.scaledImage = this.optimizedImage.execute2((Operation)new ScaleOp(this.scale, this.getScaleQuality()));
                        int prevWidth = this.scaledImage.getWidth();
                        int prevHeight = this.scaledImage.getHeight();
                        this.scaledImage.execute((Operation)new RotateOp(this.angle, this.getRotateQuality()));
                        rotationDeltaX = (prevWidth - this.scaledImage.getWidth()) / 2;
                        rotationDeltaY = (prevHeight - this.scaledImage.getHeight()) / 2;
                    }
                    imageToDraw = this.scaledImage;
                    this.shownImageWidth = this.scaledImage.getWidth();
                    this.shownImageHeight = this.scaledImage.getHeight();
                    needScaling = false;
                } else {
                    imageToDraw = this.optimizedImage;
                    this.shownImageWidth = (int)Math.round(this.scale * (double)this.optimizedImage.getWidth());
                    this.shownImageHeight = (int)Math.round(this.scale * (double)this.optimizedImage.getHeight());
                }
                this.shownImageX = -((int)Math.round(this.scale * (double)this.origin.x)) + rotationDeltaX;
                this.shownImageY = -((int)Math.round(this.scale * (double)this.origin.y)) + rotationDeltaY;
                g2 = (Graphics2D)g.create();
                if (this.clippingShape != null) {
                    ((Graphics2D)g2).clip(this.clippingShape);
                }
                PaintOp paintOp = needScaling ? new PaintOp((Graphics2D)g2, this.shownImageX, this.shownImageY, this.shownImageWidth, this.shownImageHeight, this.scaleQuality, this.previewSettings, null) : new PaintOp((Graphics2D)g2, this.shownImageX, this.shownImageY, this.previewSettings, null);
                imageToDraw.execute((Operation)paintOp);
                if (this.imageBorder != null) {
                    this.imageBorder.paintBorder(this, g2, this.shownImageX, this.shownImageY, this.shownImageWidth, this.shownImageHeight);
                }
            }
            if (g2 == null) {
                g2 = (Graphics2D)g;
            }
            for (Overlay overlay : this.overlayList) {
                if (!overlay.isVisible()) continue;
                Graphics2D g2Copy = (Graphics2D)g2.create();
                try {
                    overlay.paint(g2Copy, this);
                }
                catch (Throwable t) {
                    logger.warning("Exception in Overlay: " + t);
                    logger.throwing(CLASS, "paint()", t);
                }
                g2Copy.dispose();
            }
        }
        catch (Throwable t) {
            logger.throwing(CLASS, "paint()", t);
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
        this.paintComponents(g);
    }

    public void flushAllCaches() {
        logger.info("flushAllCaches()");
        logger.info(">>>> all caches will be recomputed from: " + this.image);
        this.flushScaledImageCache();
        this.optimizedImage = this.image != null ? (this.optimizedImageEnabled ? this.image.execute2((Operation)new OptimizeOp()) : this.image) : null;
    }

    public void flushScaledImageCache() {
        logger.info("flushScaledImageCache()");
        this.scaledImage = null;
    }

    public void moveOrigin(int deltaX, int deltaY) {
        logger.info("moveOrigin(" + deltaX + "," + deltaY + ")");
        Point position = this.getOrigin();
        position.setLocation(position.getX() + (double)deltaX, position.getY() + (double)deltaY);
        this.setOrigin(position);
    }

    public void setScale(double scale) {
        logger.info("setScale(" + scale + ")");
        this.setScale(scale, null);
    }

    public void setScale(double scale, Point pivotPoint) {
        Point newOrigin;
        Point imagePivotPoint;
        logger.info("setScale(" + scale + ", " + pivotPoint + ")");
        scale = Math.min(Math.max(scale, this.minScale), this.maxScale);
        boolean repaintEnabledSave = this.repaintEnabled;
        this.repaintEnabled = false;
        this.setFitToDisplaySize(false);
        this.internalSetScale(scale);
        if (pivotPoint != null && (imagePivotPoint = this.getPositionOverImage(pivotPoint)) != null && (newOrigin = this.computeOrigin(imagePivotPoint, pivotPoint, scale)) != null) {
            this.setOrigin(newOrigin);
        }
        this.repaintEnabled = repaintEnabledSave;
    }

    public void setMaxScale(double maxScale) {
        this.maxScale = Math.min(40.0, maxScale);
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMinScale(double minScale) {
        this.minScale = Math.max(0.01, minScale);
    }

    public double getMinScale() {
        return this.minScale;
    }

    public double getFitScale() {
        double hScale = (double)this.getAvailableWidth() / (double)this.image.getWidth();
        double vScale = (double)this.getAvailableHeight() / (double)this.image.getHeight();
        return Math.min(hScale, vScale);
    }

    public void centerImage() {
        logger.info("centerImage()");
        this.setOrigin(this.computeCenterPoint());
    }

    public void fitToDisplaySize() {
        logger.info("fitToDisplaySize()");
        if (this.image != null) {
            boolean saveRepaintEnabled = this.repaintEnabled;
            this.repaintEnabled = false;
            this.internalSetScale(this.getFitScale());
            this.centerImage();
            this.repaintEnabled = saveRepaintEnabled;
            this.repaint();
        }
    }

    public void setFitToDisplaySize(boolean fitToDisplaySize) {
        logger.info("setFitToDisplaySize(" + fitToDisplaySize + ")");
        this.fitToDisplaySize = fitToDisplaySize;
        if (fitToDisplaySize) {
            this.fitToDisplaySize();
        }
    }

    public void addImageRendererListener(EditableImageRendererListener listener) {
        this.listenerList.add(listener);
    }

    public void removeImageRendererListener(EditableImageRendererListener listener) {
        this.listenerList.remove(listener);
    }

    private void internalSetScale(double scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.flushScaledImageCache();
            this.repaint();
        }
        this.fireScaleChangedEvent();
    }

    private Point computeCenterPoint() {
        return new Point(-((int)Math.round(((double)this.getAvailableWidth() / this.scale - (double)this.image.getWidth()) / 2.0)), -((int)Math.round(((double)this.getAvailableHeight() / this.scale - (double)this.image.getHeight()) / 2.0)));
    }

    private void fireScaleChangedEvent() {
        EditableImageRendererEvent event = new EditableImageRendererEvent(this);
        for (EditableImageRendererListener listener : new ArrayList<EditableImageRendererListener>(this.listenerList)) {
            try {
                listener.scaleChanged(event);
            }
            catch (Throwable t) {
                logger.warning("Exception in listener: " + t);
                logger.throwing(CLASS, "fireScaleChangedEvent()", t);
            }
        }
    }

    private void fireAngleChangedEvent() {
        EditableImageRendererEvent event = new EditableImageRendererEvent(this);
        for (EditableImageRendererListener listener : new ArrayList<EditableImageRendererListener>(this.listenerList)) {
            try {
                listener.angleChanged(event);
            }
            catch (Throwable t) {
                logger.warning("Exception in listener: " + t);
                logger.throwing(CLASS, "fireAngleChangedEvent()", t);
            }
        }
    }

    protected void fireEditingToolActivated(EditingTool editingTool) {
        EditableImageRendererEvent event = new EditableImageRendererEvent(this, editingTool);
        for (EditableImageRendererListener listener : new ArrayList<EditableImageRendererListener>(this.listenerList)) {
            try {
                listener.toolActivated(event);
            }
            catch (Throwable t) {
                logger.warning("Exception in listener: " + t);
                logger.throwing(CLASS, "fireEditingToolActivated()", t);
            }
        }
    }

    protected void fireEditingToolDeactivated(EditingTool editingTool) {
        EditableImageRendererEvent event = new EditableImageRendererEvent(this, editingTool);
        for (EditableImageRendererListener listener : new ArrayList<EditableImageRendererListener>(this.listenerList)) {
            try {
                listener.toolDeactivated(event);
            }
            catch (Throwable t) {
                logger.warning("Exception in listener: " + t);
                logger.throwing(CLASS, "fireEditingToolDeactivated()", t);
            }
        }
    }

    private void updateScrollBars() {
        if (this.scrollBarsVisible) {
            this.horizontalScrollBar.setValues(this.origin.x, (int)Math.round((double)this.getAvailableWidth() / this.scale), 0, this.image.getWidth());
            this.verticalScrollBar.setValues(this.origin.y, (int)Math.round((double)this.getAvailableHeight() / this.scale), 0, this.image.getHeight());
        }
    }

    private void layoutScrollBars() {
        if (this.scrollBarsVisible && (this.previousWidth != this.getWidth() || this.previohsHeight != this.getHeight())) {
            this.horizontalScrollBar.setBounds(0, this.getHeight() - this.scrollbarThickness, this.getWidth() - this.scrollbarThickness, this.scrollbarThickness);
            this.verticalScrollBar.setBounds(this.getWidth() - this.scrollbarThickness, 0, this.scrollbarThickness, this.getHeight() - this.scrollbarThickness);
            this.filler.setBounds(this.getWidth() - this.scrollbarThickness, this.getHeight() - this.scrollbarThickness, this.scrollbarThickness, this.scrollbarThickness);
            this.previousWidth = this.getWidth();
            this.previohsHeight = this.getHeight();
        }
    }

    private int getAvailableWidth() {
        return this.getWidth() - (this.scrollBarsVisible ? this.scrollbarThickness : 0);
    }

    private int getAvailableHeight() {
        return this.getHeight() - (this.scrollBarsVisible ? this.scrollbarThickness : 0);
    }
}

