/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.render;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import org.imajine.image.render.EditableImageRenderer;

public class DragPanningController {
    private final EditableImageRenderer imageRenderer;
    private boolean enabled;
    private Point previousMousePosition;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent event) {
            DragPanningController.this.previousMousePosition = event.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            DragPanningController.this.previousMousePosition = null;
        }
    };
    private final MouseMotionListener dragListener = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent event) {
            Point newMousePosition = event.getPoint();
            if (DragPanningController.this.previousMousePosition != null) {
                int deltaX = (int)(newMousePosition.getX() - DragPanningController.this.previousMousePosition.getX());
                int deltaY = (int)(newMousePosition.getY() - DragPanningController.this.previousMousePosition.getY());
                double scale = DragPanningController.this.imageRenderer.getScale();
                DragPanningController.this.imageRenderer.moveOrigin(-((int)Math.round((double)deltaX / scale)), -((int)Math.round((double)deltaY / scale)));
            }
            DragPanningController.this.previousMousePosition = newMousePosition;
        }
    };

    public DragPanningController(EditableImageRenderer imageRenderer) {
        if (imageRenderer == null) {
            throw new IllegalArgumentException("imageRenderer is mandatory");
        }
        this.imageRenderer = imageRenderer;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.imageRenderer.addMouseListener(this.mouseListener);
                this.imageRenderer.addMouseMotionListener(this.dragListener);
            } else {
                this.imageRenderer.removeMouseListener(this.mouseListener);
                this.imageRenderer.removeMouseMotionListener(this.dragListener);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void centerImage() {
        this.imageRenderer.centerImage();
    }
}

