/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.render;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.imajine.image.Quality;
import org.imajine.image.render.EditableImageRenderer;
import org.imajine.image.render.ScaleController;

public class AnimatedScaleController
extends ScaleController {
    private static final String CLASS = AnimatedScaleController.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final int DEFAULT_FRAMES_PER_SECOND = 20;
    private static final int DEFAULT_DURATION = 150;
    private int framesPerSecond = 20;
    private int duration = 150;
    private Point pivot;
    private double startScale;
    private double targetScale;
    private long startTime;
    private Timer timer;
    private Quality scaleQualitySave;
    private Quality rotateQualitySave;

    public AnimatedScaleController(EditableImageRenderer imageRenderer) {
        super(imageRenderer);
    }

    public synchronized boolean isRunning() {
        return this.timer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScale(double scale, Point pivot) {
        logger.fine("setScale(" + scale + ", " + pivot + ")");
        if (pivot == null) {
            pivot = new Point(this.imageRenderer.getWidth() / 2, this.imageRenderer.getHeight() / 2);
        }
        this.pivot = pivot;
        this.startScale = this.imageRenderer.getScale();
        this.targetScale = scale;
        this.startTime = System.currentTimeMillis();
        AnimatedScaleController animatedScaleController = this;
        synchronized (animatedScaleController) {
            if (this.timer == null) {
                this.scaleQualitySave = this.imageRenderer.getScaleQuality();
                this.rotateQualitySave = this.imageRenderer.getRotateQuality();
                logger.fine(">>>> scale quality:  " + this.imageRenderer.getScaleQuality());
                logger.fine(">>>> rotate quality: " + this.imageRenderer.getRotateQuality());
                logger.fine(">>>> temporarily setting quality to FASTEST");
                this.imageRenderer.setScaleQuality(Quality.FASTEST);
                this.imageRenderer.setRotateQuality(Quality.FASTEST);
                this.timer = new Timer(1000 / this.framesPerSecond, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AnimatedScaleController.this.changeScale();
                    }
                });
                this.timer.setRepeats(true);
                this.timer.setInitialDelay(0);
                this.timer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeScale() {
        logger.fine("changeScale()");
        long deltaTime = System.currentTimeMillis() - this.startTime;
        final double scale = this.bound(this.startScale + (this.targetScale - this.startScale) * (double)deltaTime / (double)this.duration);
        this.imageRenderer.setScale(Math.max(Math.min(scale, 40.0), 0.01), this.pivot);
        logger.finest(">>>> scale: " + scale + ", targetScale: " + this.targetScale);
        if (Math.abs(scale - this.targetScale) < 0.001) {
            logger.fine(">>>> scale quality:  save: " + this.scaleQualitySave + " /// current: " + this.imageRenderer.getScaleQuality());
            logger.fine(">>>> rotate quality: save: " + this.rotateQualitySave + " /// current: " + this.imageRenderer.getRotateQuality());
            if (this.scaleQualitySave != this.imageRenderer.getScaleQuality() || this.rotateQualitySave != this.imageRenderer.getRotateQuality()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AnimatedScaleController.this.imageRenderer.setScaleQuality(AnimatedScaleController.this.scaleQualitySave);
                        AnimatedScaleController.this.imageRenderer.setRotateQuality(AnimatedScaleController.this.rotateQualitySave);
                        logger.fine(">>>> quality restored to " + AnimatedScaleController.this.scaleQualitySave + ", " + AnimatedScaleController.this.rotateQualitySave);
                        AnimatedScaleController.this.imageRenderer.flushScaledImageCache();
                        AnimatedScaleController.this.imageRenderer.repaint();
                        logger.finest(">>>> scale: " + scale + ", targetScale: " + AnimatedScaleController.this.targetScale);
                    }
                });
            }
            AnimatedScaleController animatedScaleController = this;
            synchronized (animatedScaleController) {
                if (this.timer != null) {
                    logger.fine(">>>> timer stopped");
                    this.timer.stop();
                    this.timer = null;
                    this.pivot = null;
                }
            }
        }
    }

    private double bound(double scale) {
        return Math.max(Math.min(scale, Math.max(this.startScale, this.targetScale)), Math.min(this.startScale, this.targetScale));
    }
}

