/***********************************************************************************************************************
 *
 * Mistral - open source imaging engine
 * Copyright (C) 2003-2012 by Tidalwave s.a.s.
 *
 ***********************************************************************************************************************
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 *
 ***********************************************************************************************************************
 *
 * WWW: http://mistral.imajine.org
 * SCM: https://bitbucket.org/tidalwave/mistral-src
 *
 **********************************************************************************************************************/
package org.imajine.image.render.event;

import java.util.EventObject;
import org.imajine.image.render.EditableImageRenderer;
import org.imajine.image.render.EditingTool;

/*******************************************************************************
 *
 * @author  Fabrizio Giudici
 * @version $Id: EditableImageRendererEvent.java,v 20e39e8c9fac 2012/02/02 16:35:02 fabrizio $
 *
 ******************************************************************************/
public class EditableImageRendererEvent extends EventObject
  {
    private final EditingTool editingTool;
    
    public EditableImageRendererEvent (final EditableImageRenderer imageRenderer)
      {
        this(imageRenderer, null);
      }
    
    public EditableImageRendererEvent (final EditableImageRenderer imageRenderer, final EditingTool editingTool)
      {
        super(imageRenderer);
        this.editingTool = editingTool;
      }
    
    public EditingTool getEditingTool()
      {
        return editingTool;  
      }
  }
