/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.processor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class Statistics
implements Serializable,
Iterable<Item> {
    private static final long serialVersionUID = 6751339155167897162L;
    private static final String CLASS = Statistics.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private SortedMap<String, Item> map = new TreeMap<String, Item>();

    public synchronized void addSample(String name, long value) {
        Item statItem = (Item)this.map.get(name);
        if (statItem == null) {
            statItem = new Item(name);
            this.map.put(name, statItem);
        }
        statItem.addSample(value);
    }

    public synchronized void merge(Statistics statistics) {
        for (Item statItem : statistics) {
            Item here = (Item)this.map.get(statItem.getName());
            if (here == null) {
                this.map.put(statItem.getName(), statItem);
                continue;
            }
            here.merge(statItem);
        }
    }

    public void dump() {
        for (Item item : this) {
            logger.info("STATS: >>>> " + item.getName() + ": min/max/avg " + item.getMinimum() + "/" + item.getMaximum() + "/" + item.getAverage() + " samples: " + item.getSampleCount() + " acc: " + item.getAccumulator());
        }
    }

    public void dump(PrintWriter pw) {
        for (Item item : this) {
            pw.println(item.getName() + ": min/max/avg " + item.getMinimum() + "/" + item.getMaximum() + "/" + item.getAverage() + " samples: " + item.getSampleCount() + " acc: " + item.getAccumulator());
        }
    }

    @Override
    public Iterator<Item> iterator() {
        return this.map.values().iterator();
    }

    public static class Item
    implements Serializable,
    Comparable<Item> {
        private String name;
        private long minimum = Long.MAX_VALUE;
        private long maximum = Long.MIN_VALUE;
        private long accumulator;
        private int sampleCount;

        public Item(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public long getMinimum() {
            return this.minimum;
        }

        public long getMaximum() {
            return this.maximum;
        }

        public long getAverage() {
            return this.accumulator / (long)this.sampleCount;
        }

        public long getAccumulator() {
            return this.accumulator;
        }

        public int getSampleCount() {
            return this.sampleCount;
        }

        public void addSample(long value) {
            this.minimum = Math.min(this.minimum, value);
            this.maximum = Math.max(this.maximum, value);
            this.accumulator += value;
            ++this.sampleCount;
        }

        @Override
        public int compareTo(Item o) {
            return this.name.compareTo(o.name);
        }

        protected void merge(Item otherItem) {
            this.minimum = Math.min(this.minimum, otherItem.minimum);
            this.maximum = Math.max(this.maximum, otherItem.maximum);
            this.accumulator += otherItem.accumulator;
            this.sampleCount += otherItem.sampleCount;
        }

        public String toString() {
            return "Statistics.Item[" + this.name + " min:" + this.minimum + " max:" + this.maximum + " avg:" + this.getAverage() + "]";
        }
    }
}

