/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.imajine.image.processor.ImagingTask;
import org.imajine.image.processor.ImagingTaskProcessor;

public class LocalImagingTaskProcessor
extends ImagingTaskProcessor {
    private static final String CLASS = LocalImagingTaskProcessor.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private final Collection<PoolThread> workers = new ArrayList<PoolThread>();

    public LocalImagingTaskProcessor() {
        for (int i = 0; i < Math.min(Runtime.getRuntime().availableProcessors(), maxWorkers); ++i) {
            PoolThread worker = new PoolThread("PoolThread #" + i);
            this.workers.add(worker);
            worker.start();
        }
        logger.info("Created " + this.workers.size() + " local workers");
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean hasFileAccess() {
        return true;
    }

    @Override
    public int getWorkerCount() {
        return this.workers.size();
    }

    @Override
    public Collection<Serializable> getWorkerIds() {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        for (PoolThread worker : this.workers) {
            result.add((Serializable)((Object)worker.getName()));
        }
        return result;
    }

    protected class PoolThread
    extends Thread {
        public PoolThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                LocalImagingTaskProcessor.this.changeFreeWorkerCount(1);
                ImagingTask task = LocalImagingTaskProcessor.this.getNextTask((Serializable)((Object)this.getName()), false);
                LocalImagingTaskProcessor.this.changeFreeWorkerCount(-1);
                logger.fine(Thread.currentThread().getName() + " assigned to " + task.getName());
                try {
                    task.prepare(LocalImagingTaskProcessor.this);
                    task.execute();
                }
                catch (Throwable t) {
                    logger.severe("Exception while running task: " + t);
                    logger.throwing(CLASS, "run()", t);
                }
                LocalImagingTaskProcessor.this.notifyTaskCompleted(task);
            }
        }
    }
}

