/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.imajine.image.processor.ImagingTask;
import org.imajine.image.processor.ImagingTaskProcessor;
import org.imajine.image.processor.event.ImagingTaskProcessorEvent;
import org.imajine.image.processor.event.ImagingTaskProcessorListener;

class ImagingTaskProcessorEventManager {
    private static final String CLASS = ImagingTaskProcessorEventManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private ImagingTaskProcessor processor;
    private List<ImagingTaskProcessorListener> listeners = new ArrayList<ImagingTaskProcessorListener>();

    public ImagingTaskProcessorEventManager(ImagingTaskProcessor processor) {
        this.processor = processor;
    }

    public void addListener(ImagingTaskProcessorListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ImagingTaskProcessorListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotifyTaskPosted(ImagingTask task) {
        Object object = this.processor.lock;
        synchronized (object) {
            ImagingTaskProcessorEvent event = new ImagingTaskProcessorEvent(this.processor, (Serializable)((Object)Thread.currentThread().getName()), task);
            for (ImagingTaskProcessorListener listener : new ArrayList<ImagingTaskProcessorListener>(this.listeners)) {
                try {
                    listener.notifyTaskPosted(event);
                }
                catch (Throwable t) {
                    logger.warning("Exception in fireNotifyTaskPosted(): " + t);
                    logger.throwing(CLASS, "fireNotifyTaskPosted()", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotifyTaskStarted(ImagingTask task, Serializable workerId) {
        Object object = this.processor.lock;
        synchronized (object) {
            ImagingTaskProcessorEvent event = new ImagingTaskProcessorEvent(this.processor, workerId, task);
            for (ImagingTaskProcessorListener listener : new ArrayList<ImagingTaskProcessorListener>(this.listeners)) {
                try {
                    listener.notifyTaskStarted(event);
                }
                catch (Throwable t) {
                    logger.warning("Exception in fireNotifyTaskStarted(): " + t);
                    logger.throwing(CLASS, "fireNotifyTaskStarted()", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotifyTaskCompleted(ImagingTask task) {
        Object object = this.processor.lock;
        synchronized (object) {
            ImagingTaskProcessorEvent event = new ImagingTaskProcessorEvent(this.processor, (Serializable)((Object)Thread.currentThread().getName()), task);
            for (ImagingTaskProcessorListener listener : new ArrayList<ImagingTaskProcessorListener>(this.listeners)) {
                try {
                    listener.notifyTaskCompleted(event);
                }
                catch (Throwable t) {
                    logger.warning("Exception in fireNotifyTaskCompleted(): " + t);
                    logger.throwing(CLASS, "fireNotifyTaskCompleted()", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotifyTaskPopped(ImagingTask task) {
        Object object = this.processor.lock;
        synchronized (object) {
            ImagingTaskProcessorEvent event = new ImagingTaskProcessorEvent(this.processor, (Serializable)((Object)Thread.currentThread().getName()), task);
            for (ImagingTaskProcessorListener listener : new ArrayList<ImagingTaskProcessorListener>(this.listeners)) {
                try {
                    listener.notifyTaskPopped(event);
                }
                catch (Throwable t) {
                    logger.warning("Exception in fireNotifyTaskPopped(): " + t);
                    logger.throwing(CLASS, "fireNotifyTaskPopped()", t);
                }
            }
        }
    }
}

