/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.imajine.image.processor.ImagingTask;
import org.imajine.image.processor.ImagingTaskProcessorEventManager;
import org.imajine.image.processor.LocalImagingTaskProcessor;
import org.imajine.image.processor.Statistics;
import org.imajine.image.processor.event.ImagingTaskProcessorListener;

public abstract class ImagingTaskProcessor {
    private static final String CLASS = ImagingTaskProcessor.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static ImagingTaskProcessor instance;
    private static Class<? extends ImagingTaskProcessor> defaultClass;
    private static int eventNotifierCounter;
    protected static int maxWorkers;
    protected int freeWorkers;
    protected final Object lock = new Object();
    private final List<ImagingTask> pendingTasks = Collections.synchronizedList(new ArrayList());
    private final List<ImagingTask> runningTasks = Collections.synchronizedList(new ArrayList());
    private final List<ImagingTask> completedTasks = Collections.synchronizedList(new ArrayList());
    private final Statistics statistics = new Statistics();
    private final ImagingTaskProcessorEventManager eventManager = new ImagingTaskProcessorEventManager(this);

    protected ImagingTaskProcessor() {
    }

    public static synchronized ImagingTaskProcessor getInstance() {
        if (instance == null) {
            try {
                instance = defaultClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static void setDefault(Class<? extends ImagingTaskProcessor> defaultClass) {
        ImagingTaskProcessor.defaultClass = defaultClass;
        instance = null;
    }

    public static void setMaxWorkers(int maxWorkers) {
        ImagingTaskProcessor.maxWorkers = maxWorkers;
    }

    public int getMaxWorkers() {
        return maxWorkers;
    }

    public abstract int getWorkerCount();

    public abstract Collection<Serializable> getWorkerIds();

    public abstract boolean isDistributed();

    public abstract boolean hasFileAccess();

    public void addListener(ImagingTaskProcessorListener listener) {
        this.eventManager.addListener(listener);
    }

    public void removeListener(ImagingTaskProcessorListener listener) {
        this.eventManager.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processingResourcesAvailable() {
        Object object = this.lock;
        synchronized (object) {
            return this.freeWorkers > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Collection<? extends ImagingTask> tasks) {
        logger.info(String.format("post(%s) - free workers: %d", tasks, this.freeWorkers));
        Object object = this.lock;
        synchronized (object) {
            this.pendingTasks.addAll(tasks);
            this.lock.notify();
            for (ImagingTask imagingTask : tasks) {
                logger.info(String.format(">>>> %s added to pending task list", imagingTask.getName()));
                this.eventManager.fireNotifyTaskPosted(imagingTask);
            }
        }
    }

    public void post(ImagingTask task) {
        this.post(Collections.singletonList(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWithPriority(Collection<? extends ImagingTask> tasks) {
        logger.info(String.format("postWithPriority(%s) - free workers: %d", tasks, this.freeWorkers));
        Object object = this.lock;
        synchronized (object) {
            this.pendingTasks.addAll(0, tasks);
            this.lock.notify();
            for (ImagingTask imagingTask : tasks) {
                logger.info(String.format(">>>> %s added to pending task list", imagingTask.getName()));
                this.eventManager.fireNotifyTaskPosted(imagingTask);
            }
        }
    }

    public void postWithPriority(ImagingTask task) {
        this.postWithPriority(Collections.singletonList(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends ImagingTask> Collection<T> cancellPendingTasks(Class<T> taskClass) {
        logger.info("cancellPendingTasks(" + taskClass.getName() + ")");
        ArrayList<ImagingTask> result = new ArrayList<ImagingTask>();
        Object object = this.lock;
        synchronized (object) {
            Iterator<ImagingTask> i = this.pendingTasks.iterator();
            while (i.hasNext()) {
                ImagingTask task = i.next();
                if (taskClass != null && !taskClass.getName().equals(task.getClass().getName())) continue;
                i.remove();
                result.add(task);
            }
        }
        return result;
    }

    public int getPendingTaskCount(Class<? extends ImagingTask> taskClass) {
        return this.getTaskCount(taskClass, this.pendingTasks);
    }

    public int getRunningTaskCount(Class<? extends ImagingTask> taskClass) {
        return this.getTaskCount(taskClass, this.runningTasks);
    }

    public int getCompletedTaskCount(Class<? extends ImagingTask> taskClass) {
        return this.getTaskCount(taskClass, this.completedTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ImagingTask> T popCompletedTask(Class<T> taskClass) {
        Object object = this.lock;
        synchronized (object) {
            for (ImagingTask task : this.completedTasks) {
                if (taskClass != null && !taskClass.getName().equals(task.getClass().getName())) continue;
                this.completedTasks.remove(task);
                this.eventManager.fireNotifyTaskPopped(task);
                return (T)task;
            }
        }
        throw new NoSuchElementException("No completed task of class " + taskClass);
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeFreeWorkerCount(int delta) {
        Object object = this.lock;
        synchronized (object) {
            this.freeWorkers += delta;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ImagingTask getNextTask(Serializable workerId, boolean remoteExecution) {
        ImagingTask task = null;
        while (task == null) {
            Object object = this.lock;
            synchronized (object) {
                while (this.pendingTasks.isEmpty()) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                }
                Iterator<ImagingTask> i = this.pendingTasks.iterator();
                while (i.hasNext()) {
                    ImagingTask task2 = i.next();
                    if (remoteExecution && !task2.isRemoteExecutionOk()) continue;
                    i.remove();
                    task = task2;
                    break;
                }
            }
            if (task != null) {
                object = this.lock;
                synchronized (object) {
                    this.runningTasks.add(task);
                }
                this.eventManager.fireNotifyTaskStarted(task, workerId);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyTaskCompleted(ImagingTask task) {
        logger.info("notifyTaskCompleted(" + task + ")");
        boolean duplicate = false;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = duplicate = !this.runningTasks.contains(task);
            if (!duplicate) {
                this.runningTasks.remove(task);
                this.completedTasks.add(task);
            }
        }
        if (duplicate) {
            logger.warning("Filtering out duplicated task: " + task);
        } else {
            this.statistics.merge(task.getStatistics());
            this.eventManager.fireNotifyTaskCompleted(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTaskCount(Class taskClass, Collection<ImagingTask> taskCollection) {
        int count = 0;
        Object object = this.lock;
        synchronized (object) {
            for (ImagingTask task : taskCollection) {
                if (taskClass != null && !taskClass.getName().equals(task.getClass().getName())) continue;
                ++count;
            }
        }
        return count;
    }

    static {
        defaultClass = LocalImagingTaskProcessor.class;
        maxWorkers = Integer.MAX_VALUE;
    }
}

