/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.processor;

import java.io.Serializable;
import java.util.logging.Logger;
import org.imajine.image.EditableImage;
import org.imajine.image.op.Operation;
import org.imajine.image.processor.ImagingTaskProcessor;
import org.imajine.image.processor.Statistics;

public abstract class ImagingTask
implements Serializable {
    static final long serialVersionUID = 8564150248239203504L;
    private static final String CLASS = ImagingTask.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long MEGA = 0x100000L;
    private static int uniqueIdCounter;
    private String name;
    private EditableImage result;
    private Serializable uniqueId;
    private int loggingId;
    private Statistics statistics = new Statistics();
    private Throwable throwable;
    public long latestExecutionTime;
    private boolean serializeByFile;

    public ImagingTask() {
    }

    public ImagingTask(String name, int loggingId) {
        this.serializeByFile = false;
        this.name = name;
        this.loggingId = loggingId;
        this.uniqueId = Long.toHexString(System.currentTimeMillis()) + "-" + Long.toHexString(uniqueIdCounter++);
    }

    public String getName() {
        return this.name + " #" + this.loggingId;
    }

    public Serializable getId() {
        return this.uniqueId;
    }

    public void prepare(ImagingTaskProcessor processor) throws Exception {
    }

    protected abstract void run() throws Exception;

    public final EditableImage getResult() {
        return this.result;
    }

    protected final void setResult(EditableImage result) {
        this.result = result;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public boolean isRemoteExecutionOk() {
        return true;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void dispose() {
        this.result = null;
    }

    public final String toString() {
        return this.getName() + " [" + this.uniqueId + "]";
    }

    public final int hashCode() {
        return this.uniqueId.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ImagingTask)) {
            return false;
        }
        ImagingTask task = (ImagingTask)object;
        return this.uniqueId.equals(task.uniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        try {
            logger.info("Starting " + this.name);
            long time = System.currentTimeMillis();
            try {
                this.run();
            }
            finally {
                time = System.currentTimeMillis() - time;
                this.addStatisticsSample("TOTAL", time);
                logger.info("STATS: " + this.getName() + " completed in " + time + " msec");
                Runtime runtime = Runtime.getRuntime();
                long totalMemory = runtime.totalMemory();
                long freeMemory = runtime.freeMemory();
                long usedMemory = totalMemory - freeMemory;
                logger.info("STATS: memory used: " + ImagingTask.mega(usedMemory) + ", total: " + ImagingTask.mega(totalMemory) + ", max: " + ImagingTask.mega(runtime.maxMemory()) + ", free: " + ImagingTask.mega(freeMemory));
            }
        }
        catch (Throwable e) {
            this.throwable = e;
            logger.severe("Task failed: " + this.getName() + ", " + e);
            logger.throwing(CLASS, "execute()", e);
            e.printStackTrace(System.err);
        }
        logger.info("Completed " + this.getName());
    }

    public void addStatisticsSample(String name, long value) {
        this.statistics.addSample(this.name + "." + name, value);
    }

    protected void registerTime(String name, EditableImage image) {
        this.addStatisticsSample(name, image.getLatestOperationTime());
    }

    protected <T extends Operation> T execute(EditableImage image, T operation, String operationName) {
        image.execute(operation);
        image.setNickName(operationName);
        this.registerTime(operationName, image);
        return operation;
    }

    protected <T extends Operation> T executeAndDispose(EditableImage image, T operation, String operationName) {
        T result = this.execute(image, operation, operationName);
        image.dispose();
        return result;
    }

    protected EditableImage execute2(EditableImage image, Operation operation, String operationName) {
        EditableImage result = image.execute2(operation);
        result.setNickName(operationName);
        this.registerTime(operationName, result);
        return result;
    }

    protected EditableImage execute2AndDispose(EditableImage image, Operation operation, String operationName) {
        EditableImage result = this.execute2(image, operation, operationName);
        image.dispose();
        result.setNickName(operationName);
        return result;
    }

    private static String mega(long l) {
        return "" + (l + 524288L) / 0x100000L + "M";
    }
}

