/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.image.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.imajine.image.ImageModel;
import org.imajine.image.ImageModelHolder;

class FileImageModelHolder
extends ImageModelHolder {
    private Serializable id;
    private File file;
    private transient ImageModel imageModel;

    public synchronized ImageModel get() {
        if (this.imageModel == null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.file));
                this.imageModel = (ImageModel)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.imageModel;
    }

    public void set(ImageModel imageModel) {
        this.imageModel = imageModel;
        this.id = imageModel.getId();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.file == null) {
            this.file = new File("HOLDER-" + this.id);
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.file));
            oos.writeObject(this.imageModel);
            oos.close();
        }
        out.writeObject(this.id);
        out.writeObject(this.file);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (Serializable)in.readObject();
        this.file = (File)in.readObject();
    }
}

