/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.mistral.example.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.imajine.image.EditableImage;
import org.imajine.image.Quality;
import org.imajine.image.metadata.Directory;
import org.imajine.image.metadata.EXIF;
import org.imajine.image.metadata.MakerNote;
import org.imajine.image.render.AnimatedScaleController;
import org.imajine.image.render.DragPanningController;
import org.imajine.image.render.MouseClickZoomingController;
import org.imajine.image.render.MouseWheelZoomingController;
import org.imajine.image.render.Overlay;
import org.imajine.image.render.RotationController;
import org.imajine.image.render.ScaleController;
import org.imajine.image.render.event.EditableImageRendererAdapter;
import org.imajine.image.render.event.EditableImageRendererEvent;
import org.imajine.image.render.event.EditableImageRendererListener;
import org.imajine.mistral.example.AbstractViewerPanel;
import org.imajine.mistral.example.viewer.CropOverlay;
import org.jdesktop.layout.GroupLayout;

public class ViewerPanel
extends AbstractViewerPanel {
    private static final DefaultComboBoxModel QUALITY_MODEL = new DefaultComboBoxModel(){
        {
            this.addElement(Quality.FASTEST);
            this.addElement(Quality.INTERMEDIATE);
            this.addElement(Quality.BEST);
        }
    };
    private final ScaleController scaleController;
    private final RotationController rotationController;
    private final MouseClickZoomingController mouseClickZoomingController;
    private final MouseWheelZoomingController mouseWheelZoomingController;
    private final DragPanningController panningController;
    private final CropOverlay cropOverlay;
    private final EditableImageRendererListener scaleListener;
    private JButton btActualPixels;
    private JButton btFitToWindow;
    private JButton btResetRotation;
    private JButton btZoomIn;
    private JButton btZoomOut;
    private JCheckBox cbCrop;
    private JComboBox cbQuality;
    private JCheckBox cbScrollBars;
    private JLabel lbAngle;
    private JLabel lbAngleValue;
    private JLabel lbMetadata;
    private JLabel lbQuality;
    private JLabel lbScale;
    private JLabel lbScaleValue;
    private JLabel lbSize;
    private JPanel pnStatusBar;
    private JPanel pnToolBar;
    private JPanel pnViewer;
    private JSlider slRotation;
    private JScrollPane spMetadata;

    public ViewerPanel() throws IOException {
        this.scaleController = new AnimatedScaleController(this.imageRenderer);
        this.rotationController = new RotationController(this.imageRenderer);
        this.mouseClickZoomingController = new MouseClickZoomingController(this.scaleController);
        this.mouseWheelZoomingController = new MouseWheelZoomingController(this.scaleController);
        this.panningController = new DragPanningController(this.imageRenderer);
        this.cropOverlay = new CropOverlay();
        this.scaleListener = new EditableImageRendererAdapter(){
            private static final String PHOTO_SIZE_PATTERN = "{0,number,#####}x{1,number,#####}x{2,number,##}";
            private static final String SCALE_PATTERN = "{0,number,percent}";

            public void scaleChanged(EditableImageRendererEvent event) {
                EditableImage image = ViewerPanel.this.imageRenderer.getImage();
                int width = image.getWidth();
                int height = image.getHeight();
                int depth = image.getBitsPerPixel();
                ViewerPanel.this.lbSize.setText(MessageFormat.format(PHOTO_SIZE_PATTERN, width, height, depth));
                ViewerPanel.this.lbScaleValue.setText(MessageFormat.format(SCALE_PATTERN, ViewerPanel.this.imageRenderer.getScale()));
            }

            public void angleChanged(EditableImageRendererEvent event) {
                ViewerPanel.this.lbAngleValue.setText("" + ViewerPanel.this.imageRenderer.getAngle());
            }
        };
        this.initComponents();
        this.cbQuality.setModel(QUALITY_MODEL);
        this.cbQuality.setSelectedItem(Quality.INTERMEDIATE);
        this.imageRenderer.setOptimizedImageEnabled(true);
        this.imageRenderer.addImageRendererListener(this.scaleListener);
        this.pnViewer.setLayout(new BorderLayout());
        this.pnViewer.add((Component)this.imageRenderer, "Center");
        this.mouseClickZoomingController.setClickCountToZoom(2);
        this.mouseClickZoomingController.setEnabled(true);
        this.mouseWheelZoomingController.setEnabled(true);
        this.panningController.setEnabled(true);
        this.imageRenderer.addOverlay((Overlay)this.cropOverlay);
        this.loadImage("20030701-0043.jpg");
    }

    @Override
    protected void onImageLoaded(EditableImage image) {
        EXIF exifDirectory = image.getEXIFDirectory();
        MakerNote makerNoteDirectory = image.getMakerNote();
        String exif = this.createTable((Directory)exifDirectory);
        String makerNote = this.createTable((Directory)makerNoteDirectory);
        this.lbMetadata.setText(exif);
        this.scaleController.fitToView();
    }

    private String createTable(Directory directory) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (directory != null) {
            sb.append("<table>");
            for (int code : directory.getTagCodes()) {
                String tagName = directory.getTagName(code);
                Object tagValue = directory.getObject(code);
                sb.append("<tr><td>");
                sb.append(Integer.toString(code));
                sb.append("</td><td>");
                sb.append(tagName);
                sb.append("</td><td>");
                sb.append(tagValue);
                sb.append("</td></tr>");
            }
            sb.append("</table>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private void initComponents() {
        this.pnStatusBar = new JPanel();
        this.lbScale = new JLabel();
        this.lbScaleValue = new JLabel();
        this.lbSize = new JLabel();
        this.lbAngle = new JLabel();
        this.lbAngleValue = new JLabel();
        this.pnViewer = new JPanel();
        this.spMetadata = new JScrollPane();
        this.lbMetadata = new JLabel();
        this.pnToolBar = new JPanel();
        this.btZoomIn = new JButton();
        this.btActualPixels = new JButton();
        this.btZoomOut = new JButton();
        this.btFitToWindow = new JButton();
        this.slRotation = new JSlider();
        this.cbCrop = new JCheckBox();
        this.btResetRotation = new JButton();
        this.lbQuality = new JLabel();
        this.cbQuality = new JComboBox();
        this.cbScrollBars = new JCheckBox();
        this.pnStatusBar.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.lbScale.setText("Scale:");
        this.lbScaleValue.setHorizontalAlignment(11);
        this.lbScaleValue.setText("0%");
        this.lbSize.setText(" ");
        this.lbAngle.setText("Angle:");
        this.lbAngleValue.setText("0");
        GroupLayout pnStatusBarLayout = new GroupLayout((Container)this.pnStatusBar);
        this.pnStatusBar.setLayout((LayoutManager)pnStatusBarLayout);
        pnStatusBarLayout.setHorizontalGroup((GroupLayout.Group)pnStatusBarLayout.createParallelGroup(1).add((GroupLayout.Group)pnStatusBarLayout.createSequentialGroup().add((Component)this.lbSize, -2, 181, -2).addPreferredGap(0).add((Component)this.lbScale).addPreferredGap(0).add((Component)this.lbScaleValue, -2, 54, -2).add(24, 24, 24).add((Component)this.lbAngle).addPreferredGap(0).add((Component)this.lbAngleValue).addContainerGap(460, Short.MAX_VALUE)));
        pnStatusBarLayout.setVerticalGroup((GroupLayout.Group)pnStatusBarLayout.createParallelGroup(1).add((GroupLayout.Group)pnStatusBarLayout.createParallelGroup(3).add((Component)this.lbScale).add((Component)this.lbSize).add((Component)this.lbScaleValue).add((Component)this.lbAngleValue).add((Component)this.lbAngle)));
        GroupLayout pnViewerLayout = new GroupLayout((Container)this.pnViewer);
        this.pnViewer.setLayout((LayoutManager)pnViewerLayout);
        pnViewerLayout.setHorizontalGroup((GroupLayout.Group)pnViewerLayout.createParallelGroup(1).add(0, 631, Short.MAX_VALUE));
        pnViewerLayout.setVerticalGroup((GroupLayout.Group)pnViewerLayout.createParallelGroup(1).add(0, 308, Short.MAX_VALUE));
        this.spMetadata.setMinimumSize(new Dimension(200, 8));
        this.lbMetadata.setFont(new Font("Lucida Grande", 0, 8));
        this.lbMetadata.setVerticalAlignment(1);
        this.spMetadata.setViewportView(this.lbMetadata);
        this.pnToolBar.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.btZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/org/imajine/mistral/example/viewer/icons/viewmag+.png")));
        this.btZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.btZoomInActionPerformed(evt);
            }
        });
        this.btActualPixels.setIcon(new ImageIcon(this.getClass().getResource("/org/imajine/mistral/example/viewer/icons/viewmag1.png")));
        this.btActualPixels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.btActualPixelsActionPerformed(evt);
            }
        });
        this.btZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/org/imajine/mistral/example/viewer/icons/viewmag-.png")));
        this.btZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.btZoomOutActionPerformed(evt);
            }
        });
        this.btFitToWindow.setIcon(new ImageIcon(this.getClass().getResource("/org/imajine/mistral/example/viewer/icons/viewmagfit.png")));
        this.btFitToWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.btFitToWindowActionPerformed(evt);
            }
        });
        this.slRotation.setFont(new Font("Lucida Grande", 0, 8));
        this.slRotation.setMajorTickSpacing(90);
        this.slRotation.setMaximum(180);
        this.slRotation.setMinimum(-180);
        this.slRotation.setMinorTickSpacing(10);
        this.slRotation.setPaintTicks(true);
        this.slRotation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ViewerPanel.this.slRotationStateChanged(evt);
            }
        });
        this.cbCrop.setText("Crop");
        this.cbCrop.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbCrop.setMargin(new Insets(0, 0, 0, 0));
        this.cbCrop.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ViewerPanel.this.cbCropStateChanged(evt);
            }
        });
        this.btResetRotation.setText("Level");
        this.btResetRotation.setBorder(new SoftBevelBorder(0));
        this.btResetRotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.btResetRotationActionPerformed(evt);
            }
        });
        this.lbQuality.setText("Quality:");
        this.cbQuality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.cbQualityActionPerformed(evt);
            }
        });
        this.cbScrollBars.setText("Scroll bars");
        this.cbScrollBars.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbScrollBars.setMargin(new Insets(0, 0, 0, 0));
        this.cbScrollBars.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewerPanel.this.cbScrollBarsActionPerformed(evt);
            }
        });
        GroupLayout pnToolBarLayout = new GroupLayout((Container)this.pnToolBar);
        this.pnToolBar.setLayout((LayoutManager)pnToolBarLayout);
        pnToolBarLayout.setHorizontalGroup((GroupLayout.Group)pnToolBarLayout.createParallelGroup(1).add((GroupLayout.Group)pnToolBarLayout.createSequentialGroup().add((Component)this.btZoomIn).addPreferredGap(0).add((Component)this.btZoomOut).addPreferredGap(0).add((Component)this.btFitToWindow).addPreferredGap(0).add((Component)this.btActualPixels).add(10, 10, 10).add((Component)this.cbScrollBars).addPreferredGap(0).add((Component)this.slRotation, -2, 143, -2).addPreferredGap(0).add((Component)this.btResetRotation).add(18, 18, 18).add((Component)this.lbQuality).addPreferredGap(0).add((Component)this.cbQuality, -2, 145, -2).add(11, 11, 11).add((Component)this.cbCrop).addContainerGap(144, Short.MAX_VALUE)));
        pnToolBarLayout.setVerticalGroup((GroupLayout.Group)pnToolBarLayout.createParallelGroup(1).add((GroupLayout.Group)pnToolBarLayout.createSequentialGroup().add((GroupLayout.Group)pnToolBarLayout.createParallelGroup(1).add((GroupLayout.Group)pnToolBarLayout.createParallelGroup(3).add((Component)this.btZoomIn, -2, 21, -2).add((Component)this.btZoomOut, -2, 21, -2).add((Component)this.btFitToWindow, -2, 21, -2).add((Component)this.btActualPixels, -2, 21, -2).add((Component)this.cbScrollBars)).add((Component)this.slRotation, -2, 21, -2).add((GroupLayout.Group)pnToolBarLayout.createParallelGroup(3).add((Component)this.btResetRotation, -2, 21, -2).add((Component)this.cbQuality, -2, -1, -2).add((Component)this.cbCrop).add((Component)this.lbQuality))).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.pnStatusBar, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pnViewer, -1, -1, Short.MAX_VALUE).add(4, 4, 4).add((Component)this.spMetadata, -2, 200, -2)).add(2, (Component)this.pnToolBar, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pnToolBar, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.pnViewer, -1, -1, Short.MAX_VALUE).add((Component)this.spMetadata, -1, 308, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.pnStatusBar, -2, -1, -2)));
    }

    private void cbScrollBarsActionPerformed(ActionEvent evt) {
        this.imageRenderer.setScrollBarsVisible(this.cbScrollBars.isSelected());
    }

    private void cbQualityActionPerformed(ActionEvent evt) {
        Quality quality = (Quality)this.cbQuality.getSelectedItem();
        this.imageRenderer.setScaleQuality(quality);
        this.imageRenderer.setRotateQuality(quality);
        this.repaint();
    }

    private void btResetRotationActionPerformed(ActionEvent evt) {
        this.slRotation.setValue(0);
    }

    private void cbCropStateChanged(ChangeEvent evt) {
        this.cropOverlay.setVisible(this.cbCrop.isSelected());
        this.imageRenderer.repaint();
    }

    private void slRotationStateChanged(ChangeEvent evt) {
        this.rotationController.setAngle((double)this.slRotation.getValue());
    }

    private void btFitToWindowActionPerformed(ActionEvent event) {
        this.scaleController.fitToView();
    }

    private void btActualPixelsActionPerformed(ActionEvent event) {
        this.scaleController.showActualPixels();
    }

    private void btZoomOutActionPerformed(ActionEvent event) {
        this.scaleController.zoomOut();
    }

    private void btZoomInActionPerformed(ActionEvent event) {
        this.scaleController.zoomIn();
    }
}

