/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.mistral.example.viewer;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.util.logging.LogManager;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.imajine.image.util.Platform;
import org.imajine.mistral.example.viewer.ViewerPanel;

public class Main {
    private static final Dimension WINDOW_SIZE = new Dimension(800, 600);

    public static void main(String[] args) throws Exception {
        Main.configureLogging();
        Main.createMainWindow();
    }

    private static void configureLogging() {
        try {
            InputStream is = Main.class.getResourceAsStream("log.properties");
            LogManager.getLogManager().readConfiguration(is);
            is.close();
            new File("target/logs").mkdirs();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createMainWindow() throws InvocationTargetException, HeadlessException, InterruptedException, IOException {
        if (!Platform.isMacOSX()) {
            try {
                System.setProperty("swing.aatext", "true");
            }
            catch (AccessControlException e) {
                System.err.println("Can't set anti-aliased text because of: " + e);
            }
        }
        final ViewerPanel viewerPanel = new ViewerPanel();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Mistral Viewer example");
                frame.getContentPane().add(viewerPanel);
                frame.setSize(WINDOW_SIZE);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                frame.setLocation((screenSize.width - frame.getWidth()) / 2, (screenSize.height - frame.getHeight()) / 2);
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }
}

