/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.mistral.example.viewer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.imajine.image.render.EditableImageRenderer;
import org.imajine.image.render.Overlay;

public class CropOverlay
implements Overlay {
    private boolean visible;
    private int left = 400;
    private int top = 300;
    private int width = 2000;
    private int height = 800;

    public void paint(Graphics2D g, EditableImageRenderer imageRenderer) {
        Rectangle bounds = imageRenderer.getBounds();
        Color color = new Color(0, 0, 0, 128);
        g.setColor(color);
        double scale = imageRenderer.getScale();
        Point origin = imageRenderer.getOrigin();
        int x1 = bounds.x + (int)Math.round((double)(this.left - origin.x) * scale);
        int y1 = bounds.y + (int)Math.round((double)(this.top - origin.y) * scale);
        int x2 = bounds.x + (int)Math.round((double)(this.left + this.width - origin.x) * scale);
        int y2 = bounds.y + (int)Math.round((double)(this.top + this.height - origin.y) * scale);
        this.fillRect(g, bounds.x, bounds.y, bounds.x + bounds.width - 1, y1 - 1);
        this.fillRect(g, bounds.x, y1, x1 - 1, y2);
        this.fillRect(g, x2 + 1, y1, bounds.x + bounds.width - 1, y2);
        this.fillRect(g, bounds.x, y2 + 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    private void fillRect(Graphics2D g, int x1, int y1, int x2, int y2) {
        g.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }
}

