/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.mistral.example;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.imajine.image.EditableImage;
import org.imajine.image.op.ReadOp;
import org.imajine.image.render.EditableImageRenderer;
import org.imajine.image.render.Overlay;

public class AbstractViewerPanel
extends JPanel {
    protected final EditableImageRenderer imageRenderer = new EditableImageRenderer();

    public void loadImage(String fileName) throws MalformedURLException {
        try {
            File file = new File("../../../www/images/" + fileName);
            if (!file.exists() || !file.canRead()) {
                throw new FileNotFoundException(file.toString());
            }
            this.loadImage(file);
        }
        catch (Exception e) {
            this.loadImage(new URL("https://mistral.dev.java.net/images/" + fileName));
        }
    }

    protected void loadImage(final Object input) {
        final JLabel label = new JLabel("Loading " + input + "...");
        label.setForeground(Color.WHITE);
        label.setHorizontalAlignment(0);
        label.setFont(new Font("sansserif", 1, 14));
        final Overlay overlay = new Overlay(){

            public boolean isVisible() {
                return true;
            }

            public void paint(Graphics2D g, EditableImageRenderer imageRenderer) {
                label.setBounds(imageRenderer.getBounds());
                label.paint(g);
            }
        };
        this.imageRenderer.addOverlay(overlay);
        this.imageRenderer.repaint();
        Thread loaderThread = new Thread(){

            @Override
            public void run() {
                try {
                    final EditableImage image = EditableImage.create((ReadOp)new ReadOp(input));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractViewerPanel.this.imageRenderer.setImage(image);
                            AbstractViewerPanel.this.imageRenderer.removeOverlay(overlay);
                            int hMargin = image.getWidth() / 4;
                            int vMargin = image.getHeight() / 4;
                            AbstractViewerPanel.this.imageRenderer.setMargin(new Insets(vMargin, hMargin, vMargin, hMargin));
                            AbstractViewerPanel.this.onImageLoaded(image);
                        }
                    });
                }
                catch (Throwable e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            label.setText(e.toString());
                            AbstractViewerPanel.this.imageRenderer.repaint();
                            e.printStackTrace();
                            String message = "<html>Cannot load the image.<br>An Internet connection is required.</html>";
                            String title = "Error";
                            JOptionPane.showMessageDialog(AbstractViewerPanel.this, "<html>Cannot load the image.<br>An Internet connection is required.</html>", "Error", 0);
                        }
                    });
                }
            }
        };
        loaderThread.start();
    }

    protected void onImageLoaded(EditableImage image) {
    }
}

