/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.mistral.example.histogram;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.Histogram;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.HistogramDescriptor;
import org.imajine.mistral.example.histogram.HistogramExample;

public class HistogramExampleJAI {
    private static final String CLASS = HistogramExample.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public static void main(String[] args) throws IOException {
        HistogramExampleJAI e = new HistogramExampleJAI();
        e.process();
    }

    public void process() throws IOException {
        File file = new File("../images/20030701-0043.NEF");
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        ImageReader ir = ImageIO.getImageReadersBySuffix("NEF").next();
        ir.setInput(iis);
        BufferedImage bufferedImage = ir.read(0);
        iis.close();
        PlanarImage image = PlanarImage.wrapRenderedImage((RenderedImage)bufferedImage);
        image = CropDescriptor.create((RenderedImage)image, (Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Float)Float.valueOf(600.0f), (Float)Float.valueOf(400.0f), null);
        SampleModel sampleModel = image.getSampleModel();
        int bandCount = sampleModel.getNumBands();
        int bits = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        int[] bins = new int[bandCount];
        double[] min = new double[bandCount];
        double[] max = new double[bandCount];
        int maxxx = 1 << bits;
        for (int i = 0; i < bandCount; ++i) {
            bins[i] = maxxx;
            min[i] = 0.0;
            max[i] = maxxx;
        }
        RenderedOp op = HistogramDescriptor.create((RenderedImage)image, null, (Integer)1, (Integer)1, (int[])bins, (double[])min, (double[])max, null);
        Histogram histogram = (Histogram)op.getProperty("histogram");
        for (int band = 0; band < bandCount; ++band) {
            int[] frequencies = histogram.getBins(band);
            logger.info("band #" + band + ": min=" + histogram.getLowValue(band) + " max=" + histogram.getHighValue(band) + " " + frequencies.length + " samples");
        }
    }
}

