/*
 * Decompiled with CFR 0.152.
 */
package org.imajine.mistral.example.histogram;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.imajine.image.EditableImage;
import org.imajine.image.Histogram;
import org.imajine.image.op.CropOp;
import org.imajine.image.op.HistogramOp;
import org.imajine.image.op.Operation;
import org.imajine.image.op.ReadOp;

public class HistogramExample {
    private static final String CLASS = HistogramExample.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public static void main(String[] args) throws IOException {
        HistogramExample e = new HistogramExample();
        e.process();
    }

    public void process() throws IOException {
        File file = new File("../images/20030701-0043.NEF");
        EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)file));
        logger.info("Image loaded in " + image.getLatestOperationTime() + " msec");
        image.execute((Operation)new CropOp(10, 10, 600, 400));
        logger.info("Image cropped in " + image.getLatestOperationTime() + " msec");
        Histogram histogram = ((HistogramOp)image.execute((Operation)new HistogramOp())).getHistogram();
        logger.info("Histogram computed in " + image.getLatestOperationTime() + " msec");
        for (int band = 0; band < histogram.getBandCount(); ++band) {
            int min = histogram.getMin(band);
            int max = histogram.getMax(band);
            int[] frequencies = histogram.getFrequencies(band);
            logger.info("band #" + band + ": min=" + min + " max=" + max + " " + frequencies.length + " samples");
        }
    }
}

