/*
 * Copyright 2020-2021 the original author or authors.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ifinalframework.sharding.annotation;

import java.lang.annotation.*;
import java.time.temporal.ChronoUnit;

/**
 * @author ilikly
 * @version 1.0.0
 * @see org.apache.shardingsphere.sharding.algorithm.sharding.datetime.IntervalShardingAlgorithm
 * @since 1.0.0
 */
@Repeatable(IntervalShardingStrategy.ShardingStrategies.class)
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@ShardingStrategy(strategy = ShardingStrategy.Strategy.STANDARD, type = ShardingStrategy.Algorithm.INTERVAL)
public @interface IntervalShardingStrategy {

    ShardingStrategy.Scope scope();

    String[] columns();

    @Property(Property.INTERVAL_DATETIME_PATTERN)
    String pattern();

    @Property(Property.INTERVAL_DATETIME_LOWER)
    String lower();

    @Property(Property.INTERVAL_DATETIME_UPPER)
    String upper();

    @Property(Property.INTERVAL_SHARDING_SUFFIX_PATTERN)
    String suffix();

    @Property(Property.INTERVAL_DATETIME_INTERVAL_AMOUNT)
    int interval() default 1;

    @Property(Property.INTERVAL_DATETIME_INTERVAL_UNIT)
    ChronoUnit unit() default ChronoUnit.DAYS;

    /**
     * ShardingStrategies.
     */
    @Target(ElementType.TYPE)
    @Retention(RetentionPolicy.RUNTIME)
    @interface ShardingStrategies {

        IntervalShardingStrategy[] value();

    }

}
