/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.repository.jdbc;

import com.sun.syndication.feed.atom.Category;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.ict4h.atomfeed.Configuration;
import org.ict4h.atomfeed.client.domain.Event;
import org.ict4h.atomfeed.client.domain.FailedEvent;
import org.ict4h.atomfeed.client.domain.FailedEventRetryLog;
import org.ict4h.atomfeed.client.exceptions.AtomFeedClientException;
import org.ict4h.atomfeed.client.repository.AllFailedEvents;
import org.ict4h.atomfeed.jdbc.JdbcConnectionProvider;
import org.ict4h.atomfeed.jdbc.JdbcUtils;

public class AllFailedEventsJdbcImpl
implements AllFailedEvents {
    private static Logger logger = Logger.getLogger(AllFailedEventsJdbcImpl.class);
    public static final String FAILED_EVENTS_TABLE = "failed_events";
    public static final String FAILED_EVENT_RETRY_LOG_TABLE = "failed_event_retry_log";
    public static final int ERROR_MSG_MAX_LEN = 4000;
    public static final String QUERY_FIELD_LIST = "id, feed_uri, failed_at, error_message, event_id, event_content, title, retries, tags";
    private JdbcConnectionProvider connectionProvider;

    public AllFailedEventsJdbcImpl(JdbcConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public FailedEvent get(String feedUri, String eventId) {
        ResultSet resultSet;
        PreparedStatement statement;
        block5: {
            statement = null;
            resultSet = null;
            Connection connection = this.connectionProvider.getConnection();
            String sql = String.format("select id, feed_uri, failed_at, error_message, event_id, event_content, title, retries, tags from %s where feed_uri = ? and event_id = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
            statement = connection.prepareStatement(sql);
            statement.setString(1, feedUri);
            statement.setString(2, eventId);
            resultSet = statement.executeQuery();
            List<FailedEvent> failedEvents = this.mapFailedEventsFromResultSet(resultSet);
            if (failedEvents == null || failedEvents.isEmpty()) break block5;
            FailedEvent failedEvent = failedEvents.get(0);
            this.closeAll(statement, resultSet);
            return failedEvent;
        }
        try {
            logger.info((Object)String.format("Reading failed event - feedUri=%s, eventId=%s", feedUri, eventId));
            this.closeAll(statement, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public FailedEvent getByEventId(String eventId) {
        ResultSet resultSet;
        PreparedStatement statement;
        block5: {
            statement = null;
            resultSet = null;
            Connection connection = this.connectionProvider.getConnection();
            String sql = String.format("select id, feed_uri, failed_at, error_message, event_id, event_content, title, retries, tags from %s where event_id = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
            statement = connection.prepareStatement(sql);
            statement.setString(1, eventId);
            resultSet = statement.executeQuery();
            List<FailedEvent> failedEvents = this.mapFailedEventsFromResultSet(resultSet);
            if (failedEvents.isEmpty()) break block5;
            FailedEvent failedEvent = failedEvents.get(0);
            this.closeAll(statement, resultSet);
            return failedEvent;
        }
        try {
            logger.info((Object)String.format("Reading failed event -  eventId=%s", eventId));
            this.closeAll(statement, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public List<FailedEvent> getFailedEvents(String feedUri) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            String sql = String.format("select id, feed_uri, failed_at, error_message, event_id, event_content, title, retries, tags from %s where feed_uri = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
            statement = connection.prepareStatement(sql);
            statement.setString(1, feedUri);
            resultSet = statement.executeQuery();
            List<FailedEvent> failedEvents = this.mapFailedEventsFromResultSet(resultSet);
            if (!failedEvents.isEmpty()) {
                List<FailedEvent> list = failedEvents;
                this.closeAll(statement, resultSet);
                return list;
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return null;
    }

    private void closeAll(PreparedStatement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new AtomFeedClientException(e);
        }
    }

    private List<FailedEvent> mapFailedEventsFromResultSet(ResultSet resultSet) {
        ArrayList<FailedEvent> failedEvents = new ArrayList<FailedEvent>();
        try {
            while (resultSet.next()) {
                Event event = new Event(resultSet.getString(5), resultSet.getString(6), resultSet.getString(7));
                this.setEventCategories(event, resultSet.getString(9));
                FailedEvent failedEvent = new FailedEvent(resultSet.getString(2), event, resultSet.getString(4), resultSet.getTimestamp(3).getTime(), resultSet.getInt(8));
                failedEvents.add(failedEvent);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed while mapping failedEvents from database", e);
        }
        return failedEvents;
    }

    private void setEventCategories(Event event, String tags) {
        if (!StringUtils.isBlank((CharSequence)tags)) {
            String[] eventTags;
            for (String eventTag : eventTags = tags.split(",")) {
                Category category = new Category();
                category.setTerm(eventTag);
                event.getCategories().add(category);
            }
        }
    }

    @Override
    public void addOrUpdate(FailedEvent failedEvent) {
        FailedEvent existingFailedEvent = this.get(failedEvent.getFeedUri(), failedEvent.getEventId());
        if (existingFailedEvent != null) {
            this.updateFailedEvent(failedEvent);
            return;
        }
        this.insertFailedEvent(failedEvent);
    }

    private void insertFailedEvent(FailedEvent failedEvent) {
        String sql = String.format("insert into %s (feed_uri, failed_at, error_message, event_id, event_content, error_hash_code, title, retries, tags) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
        String errorMessage = failedEvent.getErrorMessage().length() > 4000 ? failedEvent.getErrorMessage().substring(0, 4000) : failedEvent.getErrorMessage();
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(sql);
            statement.setString(1, failedEvent.getFeedUri());
            statement.setTimestamp(2, new Timestamp(failedEvent.getFailedAt()));
            statement.setString(3, errorMessage);
            statement.setString(4, failedEvent.getEventId());
            statement.setString(5, failedEvent.getEvent().getContent());
            statement.setInt(6, errorMessage.hashCode());
            statement.setString(7, failedEvent.getEvent().getTitle());
            statement.setInt(8, failedEvent.getRetries());
            statement.setString(9, this.getEventCategories(failedEvent.getEvent()));
            statement.executeUpdate();
            this.closeAll(statement, null);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, null);
                throw throwable;
            }
        }
    }

    private String getEventCategories(Event event) {
        List categories = event.getCategories();
        if (categories != null) {
            StringBuilder tags = new StringBuilder();
            for (Object category : categories) {
                if (!(category instanceof Category)) continue;
                tags.append(((Category)category).getTerm() + ",");
            }
            String tagList = tags.toString();
            if (!StringUtils.isBlank((CharSequence)tagList)) {
                return tagList.endsWith(",") ? tagList.substring(0, tagList.length() - 1) : tagList;
            }
        }
        return "";
    }

    @Override
    public void insert(FailedEventRetryLog failedEventRetryLog) {
        String sql = String.format("insert into %s (feed_uri, failed_at, error_message, error_hash_code, event_id, event_content) values (?, ?, ?, ?, ?, ?)", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENT_RETRY_LOG_TABLE));
        String errorMessage = failedEventRetryLog.getErrorMessage().length() > 4000 ? failedEventRetryLog.getErrorMessage().substring(0, 4000) : failedEventRetryLog.getErrorMessage();
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(sql);
            statement.setString(1, failedEventRetryLog.getFeedUri());
            statement.setTimestamp(2, new Timestamp(failedEventRetryLog.getFailedAt()));
            statement.setString(3, errorMessage);
            statement.setInt(4, errorMessage.hashCode());
            statement.setString(5, failedEventRetryLog.getEventId());
            statement.setString(6, failedEventRetryLog.getEventContent());
            statement.executeUpdate();
            this.closeAll(statement, null);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, null);
                throw throwable;
            }
        }
    }

    private void updateFailedEvent(FailedEvent failedEvent) {
        String sql = String.format("update %s set retries = ? where feed_uri = ? and event_id = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(sql);
            statement.setInt(1, failedEvent.getRetries());
            statement.setString(2, failedEvent.getFeedUri());
            statement.setString(3, failedEvent.getEventId());
            statement.executeUpdate();
            this.closeAll(statement, null);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, null);
                throw throwable;
            }
        }
    }

    @Override
    public List<FailedEvent> getOldestNFailedEvents(String feedUri, int numberOfFailedEvents, int numberOfRetries) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            List<FailedEvent> failedEvents;
            Connection connection = this.connectionProvider.getConnection();
            String sql = String.format("select id, feed_uri, failed_at, error_message, event_id, event_content, title, retries, tags from %s where feed_uri = ? and retries < ? order by id", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE));
            statement = connection.prepareStatement(sql);
            statement.setString(1, feedUri);
            statement.setInt(2, numberOfRetries);
            statement.setMaxRows(numberOfFailedEvents);
            resultSet = statement.executeQuery();
            List<FailedEvent> list = failedEvents = this.mapFailedEventsFromResultSet(resultSet);
            this.closeAll(statement, resultSet);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
    }

    @Override
    public int getNumberOfFailedEvents(String feedUri) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            int numberOfFailedEvents;
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(String.format("select count(*) from %s where feed_uri = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENTS_TABLE)));
            statement.setString(1, feedUri);
            resultSet = statement.executeQuery();
            int n = numberOfFailedEvents = resultSet.next() ? resultSet.getInt(1) : 0;
            this.closeAll(statement, resultSet);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
    }

    @Override
    public void remove(FailedEvent failedEvent) {
        this.deleteRecords(FAILED_EVENTS_TABLE, failedEvent.getFeedUri(), failedEvent.getEventId());
        this.deleteRecords(FAILED_EVENT_RETRY_LOG_TABLE, failedEvent.getFeedUri(), failedEvent.getEventId());
    }

    private void deleteRecords(String tableName, String feedUri, String eventId) {
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            statement = connection.prepareStatement(String.format("delete from %s where feed_uri = ? and event_id = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)tableName)));
            statement.setString(1, feedUri);
            statement.setString(2, eventId);
            statement.executeUpdate();
            this.closeAll(statement, null);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, null);
                throw throwable;
            }
        }
    }

    @Override
    public List<FailedEventRetryLog> getFailedEventRetryLogs(String eventId) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.connectionProvider.getConnection();
            String sql = String.format("select id,feed_uri,failed_at,error_message,event_id,event_content from %s where event_id = ?", JdbcUtils.getTableName((String)Configuration.getInstance().getSchema(), (String)FAILED_EVENT_RETRY_LOG_TABLE));
            statement = connection.prepareStatement(sql);
            statement.setString(1, eventId);
            resultSet = statement.executeQuery();
            List<FailedEventRetryLog> failedEventRetryLogList = this.mapFailedEventRetryLogFromResultSet(resultSet);
            if (!failedEventRetryLogList.isEmpty()) {
                List<FailedEventRetryLog> list = failedEventRetryLogList;
                this.closeAll(statement, resultSet);
                return list;
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return null;
    }

    private List<FailedEventRetryLog> mapFailedEventRetryLogFromResultSet(ResultSet resultSet) {
        ArrayList<FailedEventRetryLog> failedEventRetryLogList = new ArrayList<FailedEventRetryLog>();
        try {
            while (resultSet.next()) {
                FailedEventRetryLog failedEventRetryLog = new FailedEventRetryLog(resultSet.getString(2), resultSet.getTimestamp(3).getTime(), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6));
                failedEventRetryLogList.add(failedEventRetryLog);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed while mapping failedEvents from database", e);
        }
        return failedEventRetryLogList;
    }
}

